/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.oauth.model.CodeManager;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewOAuthMemberCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.security.CORS;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.WebhookQuery;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import java.io.IOException;
import java.util.List;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(member=true, parameters={"client"})
public final class DeleteClient
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewOAuthMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String clientId = req.getParameter((Parameter)StandardParameters.client);
        Database db = req.getDatabase();
        Client client = OAuthQuery.getClient((Database)db, (String)clientId);
        if (client != null) {
            if (!WebhookQuery.listWebhooksByClientID((Database)db, (Long)client.getId()).isEmpty()) {
                res.setError(GeneratorStatus.BAD_REQUEST, "The client can not be deleted while it has webhooks.");
                return;
            }
            String clientURI = client.getClientURI();
            boolean isAdministrator = MemberRule.isAdministrator((Database)db, (Member)req.getAuthenticatedMember());
            boolean isSelf = req.getMember().getId().equals(client.getMember().getId());
            if (!isAdministrator && !isSelf) {
                res.setError(GeneratorStatus.FORBIDDEN, "The client is not owned by this member.");
                return;
            }
            List tokens = OAuthQuery.listPersistentTokensByClientID((Database)db, (Long)client.getId());
            for (PersistentToken token : tokens) {
                token.delete(db);
            }
            AccessTokenManager.singleton().revokeForClient(client.getIdentifier());
            CodeManager.singleton().revokeForClient(client.getIdentifier());
            client.delete(db);
            CORS.removeOrigin((String)clientURI);
            XMLWriter xml = res.getXMLWriter();
            xml.openElement("client-delete");
            xml.closeElement();
        } else {
            res.setError(GeneratorStatus.NOT_FOUND, "Unable to find client");
        }
    }
}

