/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class SHA256 {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    private SHA256() {
    }

    public static String hash(byte[] data) throws UnsupportedOperationException {
        MessageDigest md = SHA256.getAlgorithm();
        md.update(data, 0, data.length);
        byte[] bytes = md.digest();
        return SHA256.toHex(bytes);
    }

    public static String hash(String text) throws UnsupportedOperationException {
        MessageDigest md = SHA256.getAlgorithm();
        md.update(text.getBytes(StandardCharsets.UTF_8), 0, text.length());
        byte[] bytes = md.digest();
        return SHA256.toHex(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hash(File file) throws IOException, UnsupportedOperationException {
        String hash;
        MessageDigest md = SHA256.getAlgorithm();
        FileInputStream fis = new FileInputStream(file);
        FileChannel in = fis.getChannel();
        try {
            MappedByteBuffer buffer = in.map(FileChannel.MapMode.READ_ONLY, 0L, in.size());
            md.update(buffer);
            byte[] bytes = md.digest();
            hash = SHA256.toHex(bytes);
        }
        finally {
            fis.close();
        }
        return hash;
    }

    private static String toHex(byte[] data) {
        StringBuilder hex = new StringBuilder(2 * data.length);
        int shift = 4;
        int byteMaskHigh = 240;
        int byteMaskLow = 15;
        for (byte b : data) {
            hex.append(HEX[(b & 0xF0) >> 4]).append(HEX[b & 0xF]);
        }
        return hex.toString();
    }

    private static MessageDigest getAlgorithm() throws UnsupportedOperationException {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }
}

