/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.util;

public final class MediaTypes {
    public static final String TEXT_PLAIN = "text/plain";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";

    private MediaTypes() {
    }

    public static String forFilename(String filename) {
        String extension = filename.substring(filename.lastIndexOf(46) + 1);
        return MediaTypes.forExtension(extension);
    }

    public static String forExtension(String extension) {
        switch (extension) {
            case "txt": {
                return TEXT_PLAIN;
            }
            case "json": {
                return APPLICATION_JSON;
            }
            case "jpeg": 
            case "jpg": {
                return "image/jpeg";
            }
            case "png": {
                return "image/png";
            }
            case "gif": {
                return "image/gif";
            }
            case "webp": {
                return "image/webp";
            }
            case "pdf": {
                return "application/pdf";
            }
        }
        return APPLICATION_OCTET_STREAM;
    }
}

