/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.util;

import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class DataUri {
    private final String mediaType;
    private final Charset encoding;
    private final boolean isBase64;
    private final byte[] bytes;

    public DataUri(String mediaType, Charset encoding, boolean isBase64, byte[] bytes) {
        this.mediaType = mediaType;
        this.encoding = encoding;
        this.isBase64 = isBase64;
        this.bytes = bytes;
    }

    public String mediaType() {
        return this.mediaType;
    }

    public Charset encoding() {
        return this.encoding;
    }

    public boolean isBase64() {
        return this.isBase64;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public static DataUri parse(String dataUri) {
        byte[] bytes;
        if (!dataUri.startsWith("data:")) {
            throw new IllegalArgumentException("Invalid data URI: must start with 'data:'");
        }
        int commaIndex = dataUri.indexOf(44);
        if (commaIndex == -1) {
            throw new IllegalArgumentException("Invalid data URI: no ',' separator found");
        }
        String[] metadata = dataUri.substring(5, commaIndex).split(";");
        String dataPart = dataUri.substring(commaIndex + 1);
        boolean isBase64 = metadata[metadata.length - 1].equals("base64");
        String mediaType = metadata[0];
        Charset charset = StandardCharsets.UTF_8;
        for (String meta : metadata) {
            if (!meta.startsWith("charset=")) continue;
            charset = Charset.forName(meta.substring(8));
        }
        if (isBase64) {
            Base64.Decoder decoder = Base64.getDecoder();
            bytes = decoder.decode(dataPart);
        } else {
            bytes = URLDecoder.decode(dataPart, charset).getBytes();
        }
        return new DataUri(mediaType, charset, isBase64, bytes);
    }
}

