/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.prompt;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.pageseeder.ai.prompt.Content;
import net.pageseeder.ai.prompt.ContentSpec;
import net.pageseeder.ai.prompt.DataContent;
import net.pageseeder.ai.prompt.FileContent;
import net.pageseeder.ai.prompt.Options;
import net.pageseeder.ai.prompt.TemplateException;
import net.pageseeder.ai.prompt.TextContent;
import net.pageseeder.ai.util.DataUri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attachment
implements ContentSpec {
    private static final Logger LOGGER = LoggerFactory.getLogger(Attachment.class);
    private final String ref;

    public Attachment(String ref) {
        this.ref = Objects.requireNonNull(ref, "Attachment ref cannot be null.");
        if (!ref.matches("^[\\p{L}_][\\p{L}0-9_-]{0,63}$")) {
            throw new IllegalArgumentException("Invalid attachment reference");
        }
    }

    public String ref() {
        return this.ref;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attachment that = (Attachment)o;
        return this.ref.equals(that.ref);
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public String toString() {
        return "{{@" + this.ref + "}}";
    }

    @Override
    public List<Content> getContents(Map<String, String> parameters, Options options) throws TemplateException {
        String value = parameters.get(this.ref);
        if (value == null) {
            if (options.isStrict()) {
                throw new TemplateException("No value found for attachment ref: " + this.ref);
            }
            LOGGER.warn("No URL found for attachment ref: {}", (Object)this.ref);
            return new ArrayList<Content>();
        }
        String[] uris = value.split("\\|");
        ArrayList<Content> contentList = new ArrayList<Content>();
        for (String uri : uris) {
            if (uri.startsWith("file:")) {
                try {
                    URI uriObject = URI.create(uri);
                    uriObject = uriObject.normalize();
                    File file = new File(uriObject);
                    this.addFileContents(file, contentList, options);
                }
                catch (Exception ex) {
                    if (options.isStrict()) {
                        throw new TemplateException("Unable to parse file URI for ref: " + this.ref);
                    }
                    LOGGER.warn("Unable to parse file URI: {}", (Object)uri, (Object)ex);
                }
                continue;
            }
            if (uri.startsWith("data:")) {
                this.addDataContent(uri, contentList, options);
                continue;
            }
            if (options.isStrict()) {
                throw new TemplateException("Unable to parse file URI for ref: " + this.ref);
            }
            LOGGER.warn("Unable to process URI: {}", (Object)uri);
        }
        return contentList;
    }

    private void addFileContents(File file, List<Content> contentList, Options options) {
        if (!file.exists()) {
            if (options.isStrict()) {
                throw new TemplateException("Unable to find file for ref " + this.ref);
            }
            LOGGER.warn("Unable to find file: {}", (Object)file.getAbsolutePath());
            return;
        }
        if (!file.isDirectory()) {
            if (options.isStrict()) {
                throw new TemplateException("File URI refers to a directory for ref: " + this.ref);
            }
            LOGGER.warn("File: {} refers to a directory", (Object)file.getAbsolutePath());
            return;
        }
        contentList.add(new FileContent(file));
    }

    private void addDataContent(String dataUri, List<Content> contentList, Options options) throws TemplateException {
        try {
            DataUri uri = DataUri.parse(dataUri);
            if ("text/plain".equals(uri.mediaType()) && uri.encoding() != null) {
                contentList.add(new TextContent(new String(uri.bytes(), uri.encoding())));
            } else {
                contentList.add(new DataContent(uri.mediaType(), uri.bytes()));
            }
        }
        catch (IllegalArgumentException ex) {
            if (options.isStrict()) {
                throw new TemplateException("Invalid data URI in ref: " + this.ref);
            }
            LOGGER.warn("Ignoring invalid data URI in ref: {}", (Object)this.ref, (Object)ex);
        }
    }
}

