/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.anthropic;

import org.eclipse.jdt.annotation.Nullable;

public enum ClaudeModel {
    CLAUDE_OPUS_4_0("claude-opus-4-0", null, null),
    CLAUDE_SONNET_4_0("claude-sonnet-4-0", null, null),
    CLAUDE_3_7_SONNET_LATEST("claude-3-7-sonnet-latest", null, null),
    CLAUDE_3_5_HAIKU_LATEST("claude-3-5-haiku-latest", null, null),
    CLAUDE_3_5_SONNET_LATEST("claude-3-5-sonnet-latest", null, null),
    CLAUDE_3_OPUS_LATEST("claude-3-opus-latest", null, null),
    CLAUDE_OPUS_4_20250514("claude-opus-4-20250514", "anthropic.claude-opus-4-20250514-v1:0", "claude-opus-4@20250514"),
    CLAUDE_SONNET_4_20250514("claude-sonnet-4-20250514", "anthropic.claude-sonnet-4-20250514-v1:0", "claude-sonnet-4@20250514"),
    CLAUDE_3_7_SONNET_20250219("claude-3-7-sonnet-20250219", "anthropic.claude-3-7-sonnet-20250219-v1:0", "claude-3-7-sonnet@20250219"),
    CLAUDE_3_5_SONNET_20241022("claude-3-5-sonnet-20241022", "anthropic.claude-3-5-sonnet-20241022-v2:0", "claude-3-5-sonnet-v2@20241022"),
    CLAUDE_3_5_SONNET_20240620("claude-3-5-sonnet-20240620", "anthropic.claude-3-5-sonnet-20240620-v1:0", "claude-3-5-sonnet-v1@20240620"),
    CLAUDE_3_5_HAIKU_20241022("claude-3-5-haiku-20241022", "anthropic.claude-3-5-haiku-20241022-v1:0", "claude-3-5-haiku@20241022"),
    CLAUDE_3_OPUS_20240229("claude-3-opus-20240229", "anthropic.claude-3-opus-20240229-v1:0", "claude-3-opus@20240229"),
    CLAUDE_3_SONNET_20240229("claude-3-sonnet-20240229", "anthropic.claude-3-sonnet-20240229-v1:0", "claude-3-sonnet@20240229"),
    CLAUDE_3_HAIKU_20240307("claude-3-haiku-20240307", "anthropic.claude-3-haiku-20240307-v1:0", "claude-3-haiku@20240307");

    private final String anthropic;
    private final @Nullable String bedrock;
    private final @Nullable String vertex;

    private ClaudeModel(@Nullable String anthropic, String bedrock, String vertex) {
        this.anthropic = anthropic;
        this.bedrock = bedrock;
        this.vertex = vertex;
    }

    public String getAnthropic() {
        return this.anthropic;
    }

    public @Nullable String getBedrock() {
        return this.bedrock;
    }

    public @Nullable String getVertex() {
        return this.vertex;
    }

    public String toString() {
        return this.anthropic;
    }

    public static ClaudeModel forId(String id) {
        for (ClaudeModel model : ClaudeModel.values()) {
            if (model.anthropic.equals(id)) {
                return model;
            }
            if (model.bedrock != null && model.bedrock.equals(id)) {
                return model;
            }
            if (model.vertex == null || !model.vertex.equals(id)) continue;
            return model;
        }
        throw new IllegalArgumentException("Unknown model Id: " + id);
    }
}

