/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.similarity;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.similarity.StreamSimilarity;

public final class JaccardSimilarity<T>
implements StreamSimilarity<T> {
    @Override
    public float score(@NotNull Stream<T> a, @NotNull Stream<T> b) {
        Set setA = a.collect(Collectors.toSet());
        Set setB = b.collect(Collectors.toSet());
        Set smaller = setA.size() < setB.size() ? setA : setB;
        Set larger = setA.size() < setB.size() ? setB : setA;
        int intersectionCount = 0;
        for (Object s : smaller) {
            if (!larger.contains(s)) continue;
            ++intersectionCount;
        }
        int unionCount = setA.size() + setB.size() - intersectionCount;
        return (float)intersectionCount / (float)unionCount;
    }
}

