/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.load.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pageseeder.diffx.config.WhiteSpaceProcessing;
import org.pageseeder.diffx.load.text.TextTokenizer;
import org.pageseeder.diffx.load.text.Tokenizers;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.impl.CharactersToken;
import org.pageseeder.diffx.token.impl.IgnorableSpaceToken;
import org.pageseeder.diffx.token.impl.SpaceToken;

public final class TokenizerByText
implements TextTokenizer {
    private final WhiteSpaceProcessing whitespace;

    public TokenizerByText(WhiteSpaceProcessing whitespace) {
        if (whitespace == null) {
            throw new NullPointerException("the white space processing must be specified.");
        }
        this.whitespace = whitespace;
    }

    @Override
    public List<TextToken> tokenize(CharSequence text) {
        if (text == null) {
            throw new NullPointerException("Character sequence is null");
        }
        if (text.length() == 0) {
            return Collections.emptyList();
        }
        int x = Tokenizers.getLeadingWhiteSpace(text);
        int y = Tokenizers.getTrailingWhiteSpace(text);
        if (x == 0 && y == 0) {
            CharactersToken token = new CharactersToken(text);
            return Collections.singletonList(token);
        }
        if (x == text.length()) {
            switch (this.whitespace) {
                case COMPARE: {
                    return Collections.singletonList(SpaceToken.getInstance(text.toString()));
                }
                case PRESERVE: {
                    return Collections.singletonList(new IgnorableSpaceToken(text.toString()));
                }
                case IGNORE: {
                    return Collections.emptyList();
                }
            }
            CharactersToken token = new CharactersToken(text);
            return Collections.singletonList(token);
        }
        List<Object> tokens = null;
        switch (this.whitespace) {
            case COMPARE: {
                tokens = new ArrayList(1 + (x > 0 ? 1 : 0) + (y > 0 ? 1 : 0));
                if (x > 0) {
                    tokens.add(SpaceToken.getInstance(text.subSequence(0, x)));
                }
                tokens.add(new CharactersToken(text.subSequence(x, text.length() - y)));
                if (y <= 0) break;
                tokens.add(SpaceToken.getInstance(text.subSequence(text.length() - y, text.length())));
                break;
            }
            case PRESERVE: {
                tokens = new ArrayList(1 + (x > 0 ? 1 : 0) + (y > 0 ? 1 : 0));
                if (x > 0) {
                    tokens.add(new IgnorableSpaceToken(text.subSequence(0, x)));
                }
                tokens.add(new CharactersToken(text.subSequence(x, text.length() - y)));
                if (y <= 0) break;
                tokens.add(new IgnorableSpaceToken(text.subSequence(text.length() - y, text.length())));
                break;
            }
            case IGNORE: {
                CharactersToken token = new CharactersToken(text.subSequence(x, text.length() - y));
                tokens = Collections.singletonList(token);
                break;
            }
        }
        return tokens;
    }
}

