/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.handler;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;

public class MuxHandler<T>
implements DiffHandler<T> {
    private final DiffHandler<T>[] handlers;

    @SafeVarargs
    public MuxHandler(DiffHandler<T> ... handlers) {
        this.handlers = handlers;
    }

    @Override
    public void start() {
        for (DiffHandler<T> handler : this.handlers) {
            handler.start();
        }
    }

    @Override
    public void handle(@NotNull Operator operator, @NotNull T token) throws IllegalStateException {
        for (DiffHandler<T> handler : this.handlers) {
            handler.handle(operator, token);
        }
    }

    @Override
    public void end() {
        for (DiffHandler<T> handler : this.handlers) {
            handler.end();
        }
    }

    public String toString() {
        return "MuxHandler -> " + Arrays.toString(this.handlers);
    }
}

