/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import org.pageseeder.diffx.algorithm.Point;
import org.pageseeder.diffx.api.Operator;

public final class EdgeSnake {
    public final Direction direction;
    public final int delta;
    public int x;
    public int y;
    public int edited;
    public int matching;
    private int diff;

    private EdgeSnake(int x, int y, Direction direction, int edited, int matching, int delta, int diff) {
        this.x = x;
        this.y = y;
        this.direction = direction;
        this.edited = edited;
        this.matching = matching;
        this.delta = delta;
        this.diff = diff;
    }

    private EdgeSnake(int x, int y, Direction direction, int edited, int matching) {
        this(x, y, direction, edited, matching, 0, -1);
    }

    public static EdgeSnake create(int aStart, int aEnd, int bStart, int bEnd, Direction direction, int xStart, int yStart, int edited, int matching) {
        EdgeSnake snake = new EdgeSnake(xStart, yStart, direction, edited, matching);
        snake.removeStubs(aStart, aEnd, bStart, bEnd);
        return snake;
    }

    public boolean isForward() {
        return this.direction.isForward;
    }

    public Point getStartPoint() {
        return new Point(this.x, this.y);
    }

    public Point getMidPoint() {
        return new Point(this.getXMid(), this.getYMid());
    }

    public Point getEndPoint() {
        return new Point(this.getXEnd(), this.getYEnd());
    }

    public int deleted() {
        return this.direction.operator == Operator.DEL ? this.edited : 0;
    }

    public int inserted() {
        return this.direction.operator == Operator.INS ? this.edited : 0;
    }

    public int getXMid() {
        if (this.direction.operator != Operator.DEL) {
            return this.x;
        }
        return this.direction.isForward ? this.x + this.edited : this.x - this.edited;
    }

    public int getYMid() {
        if (this.direction.operator != Operator.INS) {
            return this.y;
        }
        return this.direction.isForward ? this.y + this.edited : this.y - this.edited;
    }

    public int getXEnd() {
        return this.direction.isForward ? this.getXMid() + this.matching : this.getXMid() - this.matching;
    }

    public int getYEnd() {
        return this.direction.isForward ? this.getYMid() + this.matching : this.getYMid() - this.matching;
    }

    public int getDiff() {
        return this.diff;
    }

    public void setDiff(int diff) {
        this.diff = diff;
    }

    public String toString() {
        return "EdgeSnake " + String.valueOf((Object)this.direction) + ": " + String.valueOf(this.getStartPoint()) + " + (" + this.inserted() + ", " + this.deleted() + ") + " + this.matching + " -> " + String.valueOf(this.getEndPoint()) + " k=" + (this.getXMid() - this.getYMid());
    }

    private void removeStubs(int aStart, int aEnd, int bStart, int bEnd) {
        if (this.edited != 1) {
            return;
        }
        if (this.direction == Direction.DOWN && this.x == aStart && this.y == bStart - 1) {
            ++this.y;
            this.edited = 0;
        }
        if (this.direction == Direction.UP && this.x == aStart + aEnd && this.y == bStart + bEnd + 1) {
            --this.y;
            this.edited = 0;
        }
    }

    boolean append(EdgeSnake snake) {
        if (this.direction != snake.direction) {
            return false;
        }
        if (this.edited > 0 && snake.edited > 0 && this.matching == 0 && snake.matching == 0) {
            this.edited += snake.edited;
            this.matching += snake.matching;
            if (this.direction.isForward) {
                this.x = Math.min(this.x, snake.x);
                this.y = Math.min(this.y, snake.y);
            } else {
                this.x = Math.max(this.x, snake.x);
                this.y = Math.max(this.y, snake.y);
            }
            return true;
        }
        return false;
    }

    public static enum Direction {
        DOWN(Operator.INS, true),
        RIGHT(Operator.DEL, true),
        UP(Operator.INS, false),
        LEFT(Operator.DEL, false);

        final Operator operator;
        final boolean isForward;

        private Direction(Operator operator, boolean isForward) {
            this.operator = operator;
            this.isForward = isForward;
        }
    }
}

