/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.pageseeder.diffx.DiffException;
import org.pageseeder.diffx.config.DiffConfig;
import org.pageseeder.diffx.config.TextGranularity;
import org.pageseeder.diffx.config.WhiteSpaceProcessing;
import org.pageseeder.diffx.core.OptimisticXMLProcessor;
import org.pageseeder.diffx.format.DefaultXMLDiffOutput;
import org.pageseeder.diffx.load.DOMLoader;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.xml.NamespaceSet;
import org.pageseeder.diffx.xml.Sequence;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Extension {
    private static final Map<String, String> BUILDERS = new Hashtable<String, String>();

    public static Node diff(Node xml1, Node xml2, String whitespace, String granularity) throws DiffException, IOException {
        DiffConfig config = Extension.toConfig(whitespace, granularity);
        DOMLoader loader = new DOMLoader();
        loader.setConfig(config);
        Sequence seq1 = loader.load(xml1);
        Sequence seq2 = loader.load(xml2);
        if (seq1.isEmpty() && seq2.isEmpty()) {
            return null;
        }
        StringWriter out = new StringWriter();
        Extension.diff(seq1, seq2, out);
        try {
            String factory = Extension.getFactoryClass(xml1, xml2);
            return Extension.toNode(out.toString(), config, factory);
        }
        catch (Exception ex) {
            throw new DiffException("Could not generate Node from Diff result", ex);
        }
    }

    private static void diff(Sequence seq1, Sequence seq2, Writer out) {
        DefaultXMLDiffOutput output = new DefaultXMLDiffOutput(out);
        NamespaceSet namespaces = NamespaceSet.merge(seq1.getNamespaces(), seq2.getNamespaces());
        output.setNamespaces(namespaces);
        OptimisticXMLProcessor processor = new OptimisticXMLProcessor();
        processor.diff((List<? extends XMLToken>)seq1.tokens(), (List<? extends XMLToken>)seq2.tokens(), output);
    }

    private static DiffConfig toConfig(String whitespace, String granularity) {
        WhiteSpaceProcessing ws = WhiteSpaceProcessing.valueOf(whitespace);
        TextGranularity tg = TextGranularity.valueOf(granularity);
        return new DiffConfig(ws, tg);
    }

    private static Node toNode(String xml, DiffConfig config, String factory) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbFactory = factory == null ? DocumentBuilderFactory.newInstance() : DocumentBuilderFactory.newInstance(factory, Extension.class.getClassLoader());
        dbFactory.setNamespaceAware(config.isNamespaceAware());
        dbFactory.setExpandEntityReferences(true);
        dbFactory.setValidating(false);
        DocumentBuilder builder = dbFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        return document.getDocumentElement();
    }

    private static String getFactoryClass(Node xml1, Node xml2) {
        Package pkg = xml1 != null ? xml1.getClass().getPackage() : (xml2 != null ? xml2.getClass().getPackage() : null);
        return pkg == null ? null : BUILDERS.get(pkg.getName());
    }

    static {
        BUILDERS.put("net.sf.saxon.dom", "net.sf.saxon.dom.DocumentBuilderFactoryImpl");
    }
}

