/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.utils;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.flint.GroupIndex;
import com.pageseeder.search.flint.IndexAnalyzers;
import com.pageseeder.search.flint.IndexErrorID;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.help.HelpIndex;
import com.pageseeder.search.queries.Intervals;
import com.pageseeder.search.queries.PageSeederQuery;
import com.pageseeder.search.queries.Ranges;
import com.pageseeder.search.url.URLsIndex;
import com.pageseeder.search.utils.CompositeCatalog;
import com.pageseeder.search.utils.SearchException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.LuceneIndex;
import org.pageseeder.flint.lucene.LuceneUtils;
import org.pageseeder.flint.lucene.facet.DateFieldFacet;
import org.pageseeder.flint.lucene.facet.DateRangeFacet;
import org.pageseeder.flint.lucene.facet.FlexibleFieldFacet;
import org.pageseeder.flint.lucene.facet.FlexibleRangeFacet;
import org.pageseeder.flint.lucene.facet.NumericRangeFacet;
import org.pageseeder.flint.lucene.facet.StringFieldFacet;
import org.pageseeder.flint.lucene.facet.StringRangeFacet;
import org.pageseeder.flint.lucene.search.DateTermFilter;
import org.pageseeder.flint.lucene.search.NumericTermFilter;
import org.pageseeder.flint.lucene.search.StringTermFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class SearchUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchUtils.class);
    private static final Pattern FILTER_PATTERN = Pattern.compile("(.{0,500}?):(.*)");
    public static final String DEFAULT_QUESTION_FIELDS = "pstitle,pscontent";
    public static final String DEFAULT_AUTOSUGGEST_FIELDS = "pstitle,psfilename,psdocid,psid";
    public static final String GLOBAL_CATALOG_PATH = "/com/pageseeder/search/global-catalog.xml";
    private static final String GLOBAL_CATALOG_NAME = "_psglobal_";
    private static Catalog GLOBAL_CATALOG = null;

    public static void addMustClause(BooleanQuery.Builder query, Query clause) {
        BooleanQuery c;
        if (clause instanceof BooleanQuery && (c = (BooleanQuery)clause).clauses().size() == 1 && ((BooleanClause)c.iterator().next()).getOccur() == BooleanClause.Occur.MUST_NOT) {
            query.add((BooleanClause)c.iterator().next());
            return;
        }
        query.add(clause, BooleanClause.Occur.MUST);
    }

    public static String indexesToString(List<LuceneIndex> indexes) {
        return indexes.stream().map(i -> i instanceof GroupIndex ? String.valueOf(((GroupIndex)((Object)i)).getGroupID()) : (i instanceof HelpIndex ? "help" : (i instanceof URLsIndex ? "urls" : i.toString()))).collect(Collectors.joining(","));
    }

    public static @Nullable List<LuceneIndex> loadIndexes(GeneratorRequest req, @Nullable GeneratorResponse res) {
        return SearchUtils.loadIndexes(req, res, SearchUtils.loadGroupsToSearch(req, res));
    }

    public static @Nullable List<LuceneIndex> loadIndexes(GeneratorRequest req, @Nullable GeneratorResponse res, Map<Group, Boolean> groupsToSearch) {
        INCLUDE_URLS withURLs;
        if (groupsToSearch == null) {
            return null;
        }
        Database db = req.getDatabase();
        IndexMaster master = IndexMaster.getInstance();
        ArrayList<LuceneIndex> indexes = new ArrayList<LuceneIndex>();
        Group context = "true".equals(req.getParameter((Parameter)StandardParameters.allgroups)) ? null : req.getGroup();
        INCLUDE_URLS iNCLUDE_URLS = withURLs = groupsToSearch.isEmpty() && context != null ? INCLUDE_URLS.NO : SearchUtils.searchIncludesURLs(req);
        if (withURLs == INCLUDE_URLS.ONLY_URLS) {
            indexes.add(master.getURLsIndex());
            return indexes;
        }
        if (withURLs == INCLUDE_URLS.YES) {
            indexes.add(master.getURLsIndex());
        }
        for (Group group : groupsToSearch.keySet()) {
            if (!master.isIndexable(db, group)) continue;
            GroupIndex index = master.getIndex(db, group);
            if (index != null) {
                indexes.add(index);
                continue;
            }
            if (!groupsToSearch.get(group).booleanValue()) continue;
            if (res != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_GROUP, "Group not indexed: " + group.getName());
            }
            return null;
        }
        return indexes;
    }

    public static @Nullable Map<Group, Boolean> loadGroupsToSearch(GeneratorRequest req, @Nullable GeneratorResponse res) {
        Group context;
        Database db = req.getDatabase();
        String prefix = null;
        Group group = context = "true".equals(req.getParameter((Parameter)StandardParameters.allgroups)) ? null : req.getGroup();
        if (context != null) {
            if ("member".equals(context.getName())) {
                if (res != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_GROUP, "The member project cannot be searched.");
                }
                return null;
            }
            if (GroupRule.isProject((Group)context)) {
                prefix = context.getName() + "-";
            } else {
                return Collections.singletonMap(context, false);
            }
        }
        UserDetails userdetails = null;
        if (req.getMember() != null) {
            UserDetailsManager user_manager = new UserDetailsManager();
            userdetails = user_manager.get(db, req.getMember().getId());
        }
        if (userdetails == null) {
            if (res != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_GROUP, "If " + (prefix == null ? "no group" : "a project") + " is specified then member is required.");
            }
            return null;
        }
        HashMap<Group, Boolean> groupsToSearch = new HashMap<Group, Boolean>();
        List<String> filterBygroupNames = SearchUtils.filterByGroupNames(req);
        try {
            String groups = req.getParameter((Parameter)StandardParameters.groups);
            boolean admin = MemberRule.isAdministrator((Map)userdetails.flags());
            if (groups != null) {
                for (String groupname : groups.toLowerCase().split(",")) {
                    if (!filterBygroupNames.isEmpty() && !filterBygroupNames.contains(groupname)) continue;
                    if (prefix == null || groupname.startsWith(prefix)) {
                        if (!admin && userdetails.getFlags(groupname) == null) {
                            if (res != null) {
                                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_GROUP, "Access denied for group: " + groupname);
                            }
                            return null;
                        }
                        Group found = DatabaseQuery.getGroupByName((Database)db, (String)groupname);
                        if (found != null) {
                            groupsToSearch.put(found, true);
                            continue;
                        }
                        if (res != null) {
                            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_GROUP, "Group not found: " + groupname);
                        }
                        return null;
                    }
                    if (res != null) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_GROUP, "The group " + groupname + " is not under this project.");
                    }
                    return null;
                }
            } else if (prefix != null && "all".equals(req.getParameter((Parameter)StandardParameters.searchgroups)) && admin) {
                for (Group group2 : DatabaseQuery.getGroupsByNameStartsWith((Database)db, (String)prefix)) {
                    if (!filterBygroupNames.isEmpty() && !filterBygroupNames.contains(group2.getName())) continue;
                    groupsToSearch.put(group2, false);
                }
            } else {
                for (String groupName : userdetails.flags().keySet()) {
                    Group group3;
                    if (GroupRule.isPersonalGroup((String)groupName) || "member".equals(groupName) || prefix != null && !groupName.startsWith(prefix) || !filterBygroupNames.isEmpty() && !filterBygroupNames.contains(groupName) || (group3 = DatabaseQuery.getGroupByName((Database)db, (String)groupName)) == null) continue;
                    groupsToSearch.put(group3, false);
                }
            }
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to compute groups to search in", (Throwable)ex);
            if (res != null) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load groups to search in: " + ex.getMessage());
            }
            return null;
        }
        return groupsToSearch;
    }

    public static INCLUDE_URLS searchIncludesURLs(GeneratorRequest req) {
        String[] filtersParam;
        boolean predicateType;
        boolean bl = predicateType = req.getParameter((Parameter)StandardParameters.predicate) != null && "predicate".equals(req.getParameter((Parameter)StandardParameters.type, "predicate"));
        if (predicateType) {
            return INCLUDE_URLS.YES;
        }
        boolean yesToURLs = false;
        boolean otherTypes = false;
        for (String filter : filtersParam = Strings.split((String)req.getParameter((Parameter)StandardParameters.filters, ""), (char)',', (char)'\\')) {
            if ("pstype:url".equals(filter) || "+pstype:url".equals(filter)) {
                yesToURLs = true;
                continue;
            }
            if (!filter.startsWith("pstype:") && !filter.startsWith("+pstype:")) continue;
            otherTypes = true;
        }
        return yesToURLs && !otherTypes ? INCLUDE_URLS.ONLY_URLS : (!yesToURLs && otherTypes ? INCLUDE_URLS.NO : INCLUDE_URLS.YES);
    }

    public static Catalog getGlobalCatalog() {
        if (GLOBAL_CATALOG == null) {
            try (InputStream in = SearchUtils.class.getResourceAsStream(GLOBAL_CATALOG_PATH);){
                GLOBAL_CATALOG = Catalogs.loadCatalog((String)GLOBAL_CATALOG_NAME, (InputStream)in);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load global catalog file", (Throwable)ex);
                return null;
            }
        }
        return GLOBAL_CATALOG;
    }

    public static Catalog loadCatalog(List<LuceneIndex> indexes, Group mainGroup) {
        boolean withURLs = indexes.contains((Object)IndexMaster.getInstance().getURLsIndex());
        if (withURLs && indexes.size() == 1) {
            return Catalogs.getCatalog((String)"urls");
        }
        Catalog main = null;
        if (mainGroup == null) {
            main = SearchUtils.getGlobalCatalog();
        } else if (GroupRule.isProject((Group)mainGroup)) {
            main = Catalogs.getCatalog((String)GroupIndex.getCatalogName(mainGroup));
        } else {
            for (LuceneIndex index : indexes) {
                if (!(index instanceof GroupIndex) || ((GroupIndex)index).getGroupID().longValue() != mainGroup.getId().longValue()) continue;
                main = Catalogs.getCatalog((String)index.getCatalog());
                break;
            }
        }
        return main != null && withURLs ? new CompositeCatalog(main) : main;
    }

    public static Analyzer loadAnalyzer(List<LuceneIndex> indexes, Group mainGroup) {
        if (mainGroup == null) {
            try {
                return IndexAnalyzers.getAnalyzer(null);
            }
            catch (IOException | SAXException ex) {
                LOGGER.error("Failed to create global analyser", (Throwable)ex);
                return null;
            }
        }
        boolean isProject = GroupRule.isProject((Group)mainGroup);
        for (LuceneIndex index : indexes) {
            if ((!isProject || !mainGroup.getName().equals(index.getCatalog())) && (isProject || !(index instanceof GroupIndex) || ((GroupIndex)index).getGroupID().longValue() != mainGroup.getId().longValue())) continue;
            return index.getAnalyzer();
        }
        return null;
    }

    public static FlexibleFieldFacet createFacet(String name, Catalog catalog) {
        if (catalog.getNumericType(name) != null) {
            return null;
        }
        if (catalog.getResolution(name) != null) {
            return DateFieldFacet.newFacet((String)name, (DateTools.Resolution)LuceneUtils.toResolution((FlintField.Resolution)catalog.getResolution(name)));
        }
        return StringFieldFacet.newFacet((String)name);
    }

    public static List<Facet> computeFacets(GeneratorRequest req, Catalog catalog, StandardParameters param) throws SearchException {
        String[] facets;
        ArrayList<Facet> thefacets = new ArrayList<Facet>();
        for (String facet : facets = Strings.split((String)req.getParameter((Parameter)param, ""), (char)',')) {
            if (facet.isEmpty() || Ranges.isMultiRangeFacet(facet) || Intervals.isInterval(facet, catalog)) continue;
            if (catalog.getNumericType(facet) != null) {
                throw new SearchException(facet);
            }
            if (facet.charAt(facet.length() - 1) == '*') {
                for (String f : catalog.getFieldsByPrefix(facet.substring(0, facet.length() - 1))) {
                    if (thefacets.contains(f)) continue;
                    thefacets.add(new Facet(f, true));
                }
                continue;
            }
            if (thefacets.contains(facet)) continue;
            thefacets.add(new Facet(facet, false));
        }
        return thefacets;
    }

    public static FlexibleRangeFacet createRangeFacet(String name, Collection<FlexibleRangeFacet.Range> ranges, Catalog catalog) {
        if (catalog.getNumericType(name) != null) {
            NumericRangeFacet.Builder builder = new NumericRangeFacet.Builder().name(name).numeric(catalog.getNumericType(name));
            for (FlexibleRangeFacet.Range range : ranges) {
                builder.addRange(range);
            }
            return builder.build();
        }
        if (catalog.getResolution(name) != null) {
            DateRangeFacet.Builder builder = new DateRangeFacet.Builder().name(name).resolution(LuceneUtils.toResolution((FlintField.Resolution)catalog.getResolution(name)));
            for (FlexibleRangeFacet.Range range : ranges) {
                builder.addRange(range);
            }
            return builder.build();
        }
        StringRangeFacet.Builder builder = new StringRangeFacet.Builder().name(name);
        for (FlexibleRangeFacet.Range range : ranges) {
            builder.addRange(range);
        }
        return builder.build();
    }

    public static Map<String, Collection<FlexibleRangeFacet.Range>> computeRangeFacets(GeneratorRequest req, Catalog catalog, StandardParameters param) throws SearchException {
        String[] facets;
        HashMap<String, Collection<FlexibleRangeFacet.Range>> thefacets = new HashMap<String, Collection<FlexibleRangeFacet.Range>>();
        for (String facet : facets = Strings.split((String)req.getParameter((Parameter)param, ""), (char)',', (char)'\\')) {
            Collection<Ranges.Range> ranges;
            if (Intervals.isInterval(facet, catalog) || (ranges = Ranges.createMultiRanges(facet, catalog)) == null || ranges.isEmpty()) continue;
            ArrayList<FlexibleRangeFacet.Range> rr = new ArrayList<FlexibleRangeFacet.Range>();
            String fname = null;
            for (Ranges.Range r : ranges) {
                rr.add(r.toFacetRange());
                fname = r.field();
            }
            List<String> allnames = fname.charAt(fname.length() - 1) == '*' ? catalog.getFieldsByPrefix(facet.substring(0, facet.length() - 1)) : Collections.singletonList(fname);
            for (String aname : allnames) {
                thefacets.put(aname, rr);
            }
        }
        return thefacets;
    }

    public static Collection<Intervals.Interval> computeIntervalFacets(GeneratorRequest req, Catalog catalog, StandardParameters param) throws SearchException {
        String[] facets;
        ArrayList<Intervals.Interval> thefacets = new ArrayList<Intervals.Interval>();
        for (String facet : facets = Strings.split((String)req.getParameter((Parameter)param, ""), (char)',')) {
            Intervals.Interval interval;
            if (facet.isEmpty() || (interval = Intervals.createInterval(facet, catalog)) == null) continue;
            thefacets.add(interval);
        }
        return thefacets;
    }

    public static boolean disallowedGeneralField(String field) {
        String fname = field.startsWith("+") || field.startsWith("-") ? field.substring(1) : field;
        return fname.startsWith("psproperty-") || fname.startsWith("psinline-") || fname.startsWith("psblock-");
    }

    public static void addFilter(String filter, Catalog catalog, PageSeederQuery.Builder queryBuilder) {
        Matcher matcher = FILTER_PATTERN.matcher(filter);
        if (!matcher.matches()) {
            return;
        }
        String name = matcher.group(1);
        String value = matcher.group(2);
        if (!Strings.isEmpty((String)name)) {
            FlintField.NumericType nt;
            BooleanClause.Occur oc = BooleanClause.Occur.SHOULD;
            if (name.charAt(0) == '+') {
                name = name.substring(1);
                oc = BooleanClause.Occur.MUST;
            } else if (name.charAt(0) == '-') {
                name = name.substring(1);
                oc = BooleanClause.Occur.MUST_NOT;
            }
            FlintField.NumericType numericType = nt = catalog == null ? null : catalog.getNumericType(name);
            if (nt != null) {
                if (!Strings.isEmpty((String)value)) {
                    try {
                        queryBuilder.addNumericFilter(name, SearchUtils.stringToNumber(value, nt), nt, oc);
                    }
                    catch (NumberFormatException ex) {
                        LOGGER.warn("Ignoring filter {} as number is invalid format", (Object)filter);
                    }
                }
            } else if (catalog != null && catalog.getResolution(name) != null) {
                queryBuilder.addDateFilter(name, SearchUtils.stringToDate(value, LuceneUtils.toResolution((FlintField.Resolution)catalog.getResolution(name))), catalog.getResolution(name), oc);
            } else {
                queryBuilder.addStringFilter(name, value, oc);
            }
        } else {
            LOGGER.warn("Ignoring filter {} as it is an invalid format", (Object)filter);
        }
    }

    public static Query loadFiltersAsQuery(GeneratorRequest req, Catalog catalog) throws IndexException {
        String[] filters;
        HashMap<String, StringTermFilter.Builder> stringFilters = new HashMap<String, StringTermFilter.Builder>();
        HashMap<String, NumericTermFilter.Builder> numericFilters = new HashMap<String, NumericTermFilter.Builder>();
        HashMap<String, DateTermFilter.Builder> dateFilters = new HashMap<String, DateTermFilter.Builder>();
        Group context = "true".equals(req.getParameter((Parameter)StandardParameters.allgroups)) ? null : req.getGroup();
        for (String filter : filters = Strings.split((String)req.getParameter((Parameter)StandardParameters.filters, ""), (char)',', (char)'\\')) {
            if (filter.isEmpty()) continue;
            if (context == null && SearchUtils.disallowedGeneralField(filter)) {
                throw new IndexException("Cannot use field " + filter + " as a filter in global autosuggest", (Exception)new IllegalArgumentException());
            }
            Matcher matcher = FILTER_PATTERN.matcher(filter);
            if (!matcher.matches()) continue;
            String name = matcher.group(1);
            String value = matcher.group(2);
            if (!Strings.isEmpty((String)name)) {
                StringTermFilter.Builder existing;
                FlintField.NumericType nt;
                BooleanClause.Occur oc = BooleanClause.Occur.SHOULD;
                if (name.charAt(0) == '+') {
                    name = name.substring(1);
                    oc = BooleanClause.Occur.MUST;
                } else if (name.charAt(0) == '-') {
                    name = name.substring(1);
                    oc = BooleanClause.Occur.MUST_NOT;
                }
                FlintField.NumericType numericType = nt = catalog == null ? null : catalog.getNumericType(name);
                if (nt != null) {
                    if (Strings.isEmpty((String)value)) continue;
                    existing = (NumericTermFilter.Builder)numericFilters.get(name);
                    if (existing == null) {
                        numericFilters.put(name, new NumericTermFilter.Builder().name(name).addNumber(SearchUtils.stringToNumber(value, nt), oc));
                        continue;
                    }
                    existing.addNumber(SearchUtils.stringToNumber(value, nt), oc);
                    continue;
                }
                if (catalog != null && catalog.getResolution(name) != null) {
                    DateTools.Resolution reso = LuceneUtils.toResolution((FlintField.Resolution)catalog.getResolution(name));
                    DateTermFilter.Builder existing2 = (DateTermFilter.Builder)dateFilters.get(name);
                    if (existing2 == null) {
                        dateFilters.put(name, new DateTermFilter.Builder().name(name).addDate(SearchUtils.stringToDate(value, reso), oc));
                        continue;
                    }
                    existing2.addDate(SearchUtils.stringToDate(value, reso), oc);
                    continue;
                }
                existing = (StringTermFilter.Builder)stringFilters.get(name);
                if (existing == null) {
                    stringFilters.put(name, new StringTermFilter.Builder().name(name).addTerm(value, oc));
                    continue;
                }
                existing.addTerm(value, oc);
                continue;
            }
            LOGGER.warn("Ignoring filter {} as it is an invalid format", (Object)filter);
        }
        Query base = null;
        for (StringTermFilter.Builder f : stringFilters.values()) {
            base = f.build().filterQuery(base);
        }
        for (NumericTermFilter.Builder f : numericFilters.values()) {
            base = f.build().filterQuery(base);
        }
        for (DateTermFilter.Builder f : dateFilters.values()) {
            base = f.build().filterQuery(base);
        }
        return base;
    }

    private static Number stringToNumber(String s, FlintField.NumericType type) {
        if (type == FlintField.NumericType.INT) {
            return Integer.parseInt(s);
        }
        if (type == FlintField.NumericType.LONG) {
            return Long.parseLong(s);
        }
        if (type == FlintField.NumericType.FLOAT) {
            return Float.valueOf(Float.parseFloat(s));
        }
        if (type == FlintField.NumericType.DOUBLE) {
            return Double.parseDouble(s);
        }
        return null;
    }

    private static Date stringToDate(String s, DateTools.Resolution res) {
        if (res == null || s == null || s.isEmpty()) {
            return null;
        }
        ISO8601 format = ISO8601.detectFormat((String)s);
        if (format == null) {
            LOGGER.warn("Ignoring invalid date {} in filter", (Object)s);
            return null;
        }
        Object date = s;
        switch (format) {
            case CALENDAR_DATE: 
            case WEEK_DATE: {
                date = (String)date + "T00:00:00+00:00";
                break;
            }
            case YEAR: {
                date = (String)date + "-01-01T00:00:00+00:00";
                break;
            }
        }
        try {
            return ISO8601.DATETIME.parse((String)date);
        }
        catch (ParseException ex) {
            LOGGER.warn("Ignoring invalid date {} in filter", (Object)s);
            return null;
        }
    }

    public static int getIntParameter(GeneratorRequest req, StandardParameters name, int defaultValue) {
        String val = req.getParameter((Parameter)name);
        if (val == null || !val.matches("^\\d+$")) {
            return defaultValue;
        }
        return Integer.parseInt(val, 10);
    }

    private static List<String> filterByGroupNames(GeneratorRequest req) {
        boolean canOptimize = SearchUtils.canOptimizeGroupFilters(req);
        if (!canOptimize) {
            return Collections.emptyList();
        }
        String[] filters = Strings.split((String)req.getParameter((Parameter)StandardParameters.filters, ""), (char)',', (char)'\\');
        ArrayList<String> groupNames = new ArrayList<String>();
        String field = "psgroupname";
        int from = field.length() + 1;
        for (String filter : filters) {
            if (!filter.startsWith(field + ":")) continue;
            String name = filter.substring(from);
            if (name.matches("^[\\w-]+$")) {
                groupNames.add(name);
                continue;
            }
            return Collections.emptyList();
        }
        return groupNames;
    }

    private static boolean canOptimizeGroupFilters(GeneratorRequest req) {
        String[] fields;
        for (String field : fields = req.getParameter("flexiblefacets", "").split(",")) {
            if (!"psgroupname".equals(field)) continue;
            return false;
        }
        return true;
    }

    public static final class Facet {
        protected final String _field;
        protected final boolean _dynamic;

        public Facet(String f, boolean d) {
            this._field = f;
            this._dynamic = d;
        }

        public String field() {
            return this._field;
        }

        public boolean dynamic() {
            return this._dynamic;
        }
    }

    private static enum INCLUDE_URLS {
        ONLY_URLS,
        YES,
        NO;

    }
}

