/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.utils;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.common.net.URLCoder;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSRequester;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.pageseeder.flint.indexing.IndexBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingThreadBase
extends ProcessThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingThreadBase.class);
    protected static final String SITE_PREFIX = GlobalSettings.getSitePrefix();
    protected int total = 0;
    protected int alreadyDone = 0;
    protected final PSRequester requester;
    protected List<String> indexIgnoreFolders = new ArrayList<String>();
    protected final List<INDEXTYPE> typesToIndex = new ArrayList<INDEXTYPE>();

    protected IndexingThreadBase(String username, String name, Group group) {
        super(username, name, group);
        this.requester = new PSRequester(name);
    }

    public void process() {
    }

    protected boolean indexComments(Collection<XLink> comments, Group group, IndexBatch batch, Database db) {
        if (comments == null || comments.isEmpty()) {
            return true;
        }
        IndexMaster master = IndexMaster.getInstance();
        Set<Group> grps = Collections.singleton(group);
        for (XLink comment : comments) {
            master.indexBatch(db, batch, comment, grps.iterator(), this.requester);
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Added " + ("Workflow".equals(comment.getContentRole()) ? "workflow " : "comment ") + comment.getId());
            ++this.alreadyDone;
            ++this.alreadyDone;
            if (!this.wasCancelled()) continue;
            return false;
        }
        return true;
    }

    protected boolean indexVersions(Map<Long, URI> versions, Group group, IndexBatch batch, Database db) {
        if (versions == null || versions.isEmpty()) {
            return true;
        }
        Set<Group> grps = Collections.singleton(group);
        IndexMaster master = IndexMaster.getInstance();
        for (Map.Entry<Long, URI> uriVersion : versions.entrySet()) {
            Long version = uriVersion.getKey();
            URI uri = uriVersion.getValue();
            master.indexBatch(db, batch, uri, version, grps.iterator(), this.requester);
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Added version " + version + " of URI " + uri.getId());
            ++this.alreadyDone;
            if (!this.wasCancelled()) continue;
            return false;
        }
        return true;
    }

    protected Collection<XLink> findComments(Database db, Group group) throws QueryFailedException {
        if (this.typesToIndex.contains((Object)INDEXTYPE.COMMENT)) {
            Collection comments = DatabaseQuery.getCommentsByGroupId((Database)db, (Long)group.getId());
            List workflows = DatabaseQuery.getWorkflowsByGroupId((Database)db, (Long)group.getId());
            comments.addAll(workflows);
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + comments.size() + " comments to index");
            return comments;
        }
        return Collections.emptyList();
    }

    protected Map<Long, URI> findVersions(Database db, Group group, List<URIToIndex> filefolders) throws QueryFailedException {
        HashMap<Long, URI> versions = new HashMap<Long, URI>();
        if (this.typesToIndex.contains((Object)INDEXTYPE.VERSION)) {
            try {
                Properties props = GroupProperties.get((Database)db, (Group)group);
                if (!"true".equals(props.getProperty("indexVersions"))) {
                    return versions;
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load group properties for {}", (Object)group, (Object)ex);
                return versions;
            }
            for (URIToIndex doc : filefolders) {
                String path;
                URI uri;
                if (doc.isFolder || (uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)doc.scheme, (String)doc.host, (Integer)doc.port, (String)(path = RuleUtils.urlEncodeFilepath((String)doc.path)))) == null) continue;
                List xlinks = URIRule.getReleasesForURI((Database)db, (URI)uri);
                for (XLink xl : xlinks) {
                    versions.put(xl.getId(), uri);
                }
            }
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + versions.size() + " versions to index");
        }
        return versions;
    }

    protected void addGroupURI(Collection<URIToIndex> filefolders, GroupURI guri, Database db) throws QueryFailedException, IOException {
        String path = guri.getPath();
        if (path.startsWith(GlobalSettings.get((String)"servletPrefix")) || URIRule.isExternal((GroupURI)guri) || !path.endsWith("/*")) {
            return;
        }
        if (!(path = GroupURIs.truncatePath((String)path)).startsWith(GlobalSettings.getSitePrefix() + "/member/")) {
            LOGGER.debug("Indexing folder: " + path);
            filefolders.add(new URIToIndex(guri.getScheme(), guri.getHost().getName(), guri.getPort(), URLCoder.decode((String)path), true));
        }
        Collection uris = DatabaseQuery.getURIsBySchemeHostPortDirectoryMediaDocumentType((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)path, null, null, (boolean)false);
        for (URI u : uris) {
            if (URIRule.isFolder((URI)u)) {
                this.addFolder(filefolders, u, db);
                continue;
            }
            LOGGER.debug("Indexing file: " + u.getPath());
            filefolders.add(new URIToIndex(u.getScheme(), u.getHost().getName(), u.getPort(), u.getDecodedPath(), false));
        }
    }

    protected boolean addFolder(Collection<URIToIndex> filefolders, URI uri, Database db) throws QueryFailedException, IOException {
        if (IndexUtils.shouldIgnoreURI(uri, db) || !URIRule.isFolder((URI)uri) || uri.getPath().endsWith("/")) {
            return false;
        }
        LOGGER.debug("Indexing folder: " + uri.getPath());
        filefolders.add(new URIToIndex(uri.getScheme(), uri.getHost().getName(), uri.getPort(), uri.getDecodedPath(), true));
        Collection uris = DatabaseQuery.getURIsBySchemeHostPortSubpathMediaDocumentType((Database)db, (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)(uri.getPath() + "/"), null, null);
        for (URI u : uris) {
            LOGGER.debug("Indexing file/folder: " + u.getPath());
            filefolders.add(new URIToIndex(u.getScheme(), u.getHost().getName(), u.getPort(), u.getDecodedPath(), URIRule.isFolder((URI)u)));
        }
        return true;
    }

    protected boolean indexFileFolder(URIToIndex doc, Group group, Member member, IndexBatch batch, Database db, Transaction tr) {
        if (IndexMaster.shouldIgnoreURI(doc.path)) {
            return true;
        }
        if (this.wasCancelled()) {
            return false;
        }
        try {
            String path = RuleUtils.urlEncodeFilepath((String)doc.path);
            URI uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)doc.scheme, (String)doc.host, (Integer)doc.port, (String)path);
            if (uri == null && doc.isFolder) {
                Collection guris = URIRule.matchGroupURIs((Database)db, (String)doc.scheme, (String)doc.host, (Integer)doc.port, (String)path);
                try {
                    uri = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleTypeGroupURIs((Database)db, (Transaction)tr, (String)doc.scheme, (String)doc.host, (Integer)doc.port, (String)path, null, null, null, (String)"folder", (boolean)true, (Collection)guris);
                    if (uri != null) {
                        URIRule.addURIHistoryXLink((URI)uri, (Member)member, (Date)uri.getDateCreated(), (String)"creation", null, (Database)db);
                    }
                }
                catch (DatabaseException e) {
                    this.updateStatus(ProcessStage.Status.WARNING, "Failed to create URI for path " + path + ": " + e.getMessage());
                    batch.increaseTotal(-1);
                    return true;
                }
            }
            if (uri == null) {
                tr.abort();
                this.updateStatus(ProcessStage.Status.WARNING, "No corresponding URI for file with path " + doc.path);
                batch.increaseTotal(-1);
                return true;
            }
            if (this.wasCancelled()) {
                return false;
            }
            IndexMaster.getInstance().indexBatch(db, batch, uri, Collections.singleton(group).iterator(), this.requester);
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Added URI " + uri.getId());
            ++this.alreadyDone;
        }
        catch (DatabaseException ex) {
            this.updateStatus(ProcessStage.Status.WARNING, "Database Error: " + ex.getMessage());
        }
        return true;
    }

    protected static final class URIToIndex {
        private final String scheme;
        private final String host;
        private final Integer port;
        private final String path;
        private final boolean isFolder;

        URIToIndex(String s, String h, Integer p, String pa, boolean f) {
            this.scheme = s;
            this.host = h;
            this.port = p;
            this.path = pa;
            this.isFolder = f;
        }
    }

    public static enum INDEXTYPE {
        DOCUMENT,
        COMMENT,
        VERSION;

    }
}

