/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.utils;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.indexing.FlintField;

public class CompositeCatalog
extends Catalog {
    private final Catalog mainCatalog;
    private final Catalog urlsCatalog;

    public CompositeCatalog(Catalog main) {
        super("composite catalog for " + main.name());
        this.mainCatalog = main;
        this.urlsCatalog = Catalogs.getCatalog((String)"urls");
    }

    public FlintField.NumericType getNumericType(String fieldname) {
        if (this.urlsCatalog == null && this.mainCatalog == null) {
            return null;
        }
        FlintField.NumericType num = this.urlsCatalog == null ? null : this.urlsCatalog.getNumericType(fieldname);
        return num == null ? this.mainCatalog.getNumericType(fieldname) : num;
    }

    public boolean isTokenized(String fieldname) {
        return this.urlsCatalog != null && this.urlsCatalog.isTokenized(fieldname) || this.mainCatalog != null && this.mainCatalog.isTokenized(fieldname);
    }

    public FlintField.DocValuesType getDocValuesType(String fieldname) {
        if (this.urlsCatalog == null && this.mainCatalog == null) {
            return null;
        }
        FlintField.DocValuesType vt = this.urlsCatalog == null ? null : this.urlsCatalog.getDocValuesType(fieldname);
        return vt == null ? this.mainCatalog.getDocValuesType(fieldname) : vt;
    }

    public Collection<String> getFieldsByPrefix(String prefix) {
        if (this.urlsCatalog == null && this.mainCatalog == null) {
            return Collections.emptyList();
        }
        Collection fields = this.urlsCatalog == null ? null : this.urlsCatalog.getFieldsByPrefix(prefix);
        Collection fields2 = this.mainCatalog.getFieldsByPrefix(prefix);
        if (fields != null) {
            if (fields2 != null) {
                for (String field : fields2) {
                    if (fields.contains(field)) continue;
                    fields.add(field);
                }
            }
            return fields;
        }
        return fields2 == null ? Collections.emptyList() : fields2;
    }

    public FlintField.Resolution getResolution(String fieldname) {
        if (this.urlsCatalog == null && this.mainCatalog == null) {
            return null;
        }
        FlintField.Resolution resolution = this.urlsCatalog == null ? null : this.urlsCatalog.getResolution(fieldname);
        return resolution == null ? this.mainCatalog.getResolution(fieldname) : resolution;
    }

    public SimpleDateFormat getDateFormat(String fieldname) {
        if (this.urlsCatalog == null && this.mainCatalog == null) {
            return null;
        }
        SimpleDateFormat format = this.urlsCatalog == null ? null : this.urlsCatalog.getDateFormat(fieldname);
        return format == null ? this.mainCatalog.getDateFormat(fieldname) : format;
    }
}

