/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.url;

import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.common.properties.Settings;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import org.apache.lucene.analysis.Analyzer;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.LuceneIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLsIndex
extends LuceneIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLsIndex.class);
    private static final String INDEX_TEMPLATE_FOLDER = "index";
    public static final String CATALOG_NAME = "urls";
    private final Template _template;
    private final Map<String, String> originalParameters = new ConcurrentHashMap<String, String>();

    public URLsIndex(File dir, Analyzer analyzer) throws IOException, IndexException {
        super(CATALOG_NAME, dir, analyzer);
        this.addTimezoneParameters();
        this._template = Template.DEFAULT;
    }

    public String getCatalog() {
        return CATALOG_NAME;
    }

    public Collection<FlintField> getFields(Content content) {
        return Collections.emptyList();
    }

    public Templates getTemplates(ContentType type, String mimeType) {
        Templates loaded = super.getTemplates(type, mimeType);
        if (loaded != null) {
            return loaded;
        }
        String templateName = "index-" + mimeType.toLowerCase().replaceAll("\\W", "-");
        File template = this.findIndexTemplate(templateName);
        if (template == null) {
            template = this.findIndexTemplate(INDEX_TEMPLATE_FOLDER);
        }
        if (template == null) {
            return null;
        }
        try {
            this.setTemplates(type, mimeType, template.toURI());
        }
        catch (TransformerException ex) {
            LOGGER.error("Failed to load iXML templates {}", (Object)template.getName(), (Object)ex);
        }
        return super.getTemplates(type, mimeType);
    }

    public Map<String, String> getParameters(Content content) {
        return this.originalParameters;
    }

    public String toString() {
        return "Global index for URLs";
    }

    public File findIndexTemplate(String name) {
        File webapp = new File(Settings.getContextPath());
        return TemplateFiles.find((Template)this._template, (TemplateZone)TemplateFiles.Zone.TEMPLATE, (File)webapp, (String)("index/" + name + ".xsl"));
    }

    private void addTimezoneParameters() {
        TimeZone tz = TimeZone.getDefault();
        this.originalParameters.put("timezone.offset", this.offsetAsString(tz.getOffset(System.currentTimeMillis())));
        this.originalParameters.put("timezone.rawoffset", this.offsetAsString(tz.getRawOffset()));
    }

    private String offsetAsString(int offsetinMS) {
        double offset = offsetinMS / 3600000;
        double offsetAbs = Math.abs(offset);
        int minutes = (int)(offsetAbs - (double)((int)offsetAbs)) * 100;
        return (offset != offsetAbs ? "-" : "+") + (offsetAbs < 10.0 ? "0" : "") + (int)offsetAbs + ":" + (minutes < 10 ? "0" : "") + minutes;
    }
}

