/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.queries;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.eclipse.jdt.annotation.NonNull;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.facet.FlexibleRangeFacet;
import org.pageseeder.flint.lucene.query.DateParameter;
import org.pageseeder.flint.lucene.query.NumericRange;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWriter;

public final class Ranges {
    private static final Pattern RANGE_PATTERN = Pattern.compile("(.+):(\\[|\\{)(.{1,500})(\\]|\\})");
    private static final String DATE_PATTERN = "\\d\\d\\d\\d-\\d\\d-\\d\\d";
    private static final String NUMBER_PATTERN = "\\d+";
    private static final String FLOAT_PATTERN = "\\d+\\.\\d+";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    private Ranges() {
    }

    public static boolean isRangeFacet(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = RANGE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String[] split = Strings.split((String)matcher.group(3), (char)';', (char)'\\');
        return split.length == 2 && !split[0].isEmpty() && !split[1].isEmpty();
    }

    public static boolean isMultiRangeFacet(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = RANGE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String[] split = Strings.split((String)matcher.group(3), (char)';', (char)'\\');
        return split.length >= 2;
    }

    public static Range createRange(String string, Catalog catalog) {
        String max;
        if (string == null) {
            return null;
        }
        Matcher matcher = RANGE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String field = matcher.group(1);
        boolean includeMin = "[".equals(matcher.group(2));
        boolean includeMax = "]".equals(matcher.group(4));
        String[] split = Strings.split((String)matcher.group(3), (char)';', (char)'\\');
        if (split.length != 2) {
            return null;
        }
        String min = split[0].isEmpty() ? null : split[0];
        String string2 = max = split[1].isEmpty() ? null : split[1];
        if (min == null && max == null) {
            return null;
        }
        if (catalog != null) {
            return Ranges.createCatalogRange(catalog, field, min, max, includeMin, includeMax);
        }
        return Ranges.createFallbackRange(field, min, max, includeMin, includeMax);
    }

    public static Collection<Range> createMultiRanges(String string, Catalog catalog) {
        if (string == null) {
            return null;
        }
        Matcher matcher = RANGE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String field = matcher.group(1);
        boolean includeAllMin = "[".equals(matcher.group(2));
        boolean includeLastMax = "]".equals(matcher.group(4));
        ArrayList<Range> theranges = new ArrayList<Range>();
        String[] values = Strings.split((String)matcher.group(3), (char)';', (char)'\\');
        if (values.length == 0) {
            return null;
        }
        String lowest = values[0];
        if (values.length > 1) {
            for (int i = 1; i < values.length; ++i) {
                Range r;
                String max;
                String highest = values[i];
                String min = lowest.isEmpty() ? null : lowest;
                String string2 = max = highest.isEmpty() ? null : highest;
                if (min == null && max == null) {
                    return null;
                }
                boolean includeMax = i == values.length - 1 ? includeLastMax : !includeAllMin;
                Range range = r = catalog != null ? Ranges.createCatalogRange(catalog, field, min, max, includeAllMin, includeMax) : Ranges.createFallbackRange(field, min, max, includeAllMin, includeMax);
                if (r != null) {
                    theranges.add(r);
                }
                lowest = highest;
            }
        }
        return theranges;
    }

    @Deprecated
    public static void toXML(List<Range> ranges, XMLWriter xml) throws IOException {
        if (ranges == null || ranges.isEmpty()) {
            return;
        }
        xml.openElement("ranges");
        for (Range range : ranges) {
            range.toParameter().toXML(xml);
        }
        xml.closeElement();
    }

    public static void print(List<Range> ranges, OutputPrinter out) {
        if (ranges == null || ranges.isEmpty()) {
            return;
        }
        out.startCollection("ranges");
        for (Range range : ranges) {
            range.print(out);
        }
        out.endCollection();
    }

    private static Range createCatalogRange(Catalog catalog, String field, String min, String max, boolean includeMin, boolean includeMax) {
        FlintField.NumericType num = catalog.getNumericType(field);
        if (num != null) {
            Double from = null;
            Double to = null;
            try {
                switch (num) {
                    case DOUBLE: {
                        from = min == null ? null : Double.valueOf(Double.parseDouble(min));
                        to = max == null ? null : Double.valueOf(Double.parseDouble(max));
                        break;
                    }
                    case FLOAT: {
                        from = min == null ? null : Float.valueOf(Float.parseFloat(min));
                        to = max == null ? null : Float.valueOf(Float.parseFloat(max));
                        break;
                    }
                    case INT: {
                        from = min == null ? null : Integer.valueOf(Integer.parseInt(min));
                        to = max == null ? null : Integer.valueOf(Integer.parseInt(max));
                        break;
                    }
                    case LONG: {
                        from = min == null ? null : Long.valueOf(Long.parseLong(min));
                        to = max == null ? null : Long.valueOf(Long.parseLong(max));
                    }
                }
            }
            catch (NumberFormatException ex) {
                return null;
            }
            if (from != null || to != null) {
                return new NumberRange(field, from, to, includeMin, includeMax);
            }
        }
        return Ranges.createFallbackRange(field, min, max, includeMin, includeMax);
    }

    private static Range createFallbackRange(String field, String min, String max, boolean includeMin, boolean includeMax) {
        DateRange dateRange = Ranges.createDateRange(field, min, max, includeMin, includeMax);
        if (dateRange != null) {
            return dateRange;
        }
        Range numberRange = Ranges.createNumberRange(field, min, max, includeMin, includeMax);
        if (numberRange != null) {
            return numberRange;
        }
        return new StringRange(field, min, max, includeMin, includeMax);
    }

    private static DateRange createDateRange(String field, String min, String max, boolean includeMin, boolean includeMax) {
        Date from = Ranges.tryParseDate(min);
        Date to = Ranges.tryParseDate(max);
        DateTools.Resolution res = DateTools.Resolution.SECOND;
        return from == null && to == null ? null : new DateRange(field, from, to, includeMin, includeMax, false, res);
    }

    private static Date tryParseDate(String date) {
        Date d = Ranges.tryParseISO8601(date);
        if (d == null) {
            d = Ranges.tryParseLegacy(date);
        }
        return d;
    }

    private static Date tryParseISO8601(String date) {
        try {
            return date == null ? null : ISO8601.parseAuto((String)date);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    private static Date tryParseLegacy(String date) {
        if (!Strings.isEmpty((String)date) && date.matches(DATE_PATTERN)) {
            try {
                return dateFormat.parse(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Range createNumberRange(String field, String min, String max, boolean includeMin, boolean includeMax) {
        boolean emptyMin = Strings.isEmpty((String)min);
        boolean emptyMax = Strings.isEmpty((String)max);
        Float from = null;
        Float to = null;
        if (!emptyMin && min.matches(FLOAT_PATTERN)) {
            from = Float.valueOf(Float.parseFloat(min));
        }
        if (!emptyMax && max.matches(FLOAT_PATTERN)) {
            to = Float.valueOf(Float.parseFloat(max));
        }
        if (from != null || to != null) {
            if (from == null && !emptyMin && min.matches(NUMBER_PATTERN)) {
                from = Float.valueOf(Float.parseFloat(min));
            }
            if (to == null && !emptyMax && max.matches(NUMBER_PATTERN)) {
                to = Float.valueOf(Float.parseFloat(max));
            }
            if (from != null && emptyMax || to != null && emptyMin) {
                return new NumberRange(field, from, to, includeMin, includeMax);
            }
        }
        Long fromLong = null;
        Long toLong = null;
        if (!emptyMin && min.matches(NUMBER_PATTERN)) {
            fromLong = Long.parseLong(min);
        }
        if (!emptyMax && max.matches(NUMBER_PATTERN)) {
            toLong = Long.parseLong(max);
        }
        if (fromLong != null && emptyMax || toLong != null && emptyMin) {
            return new NumberRange(field, fromLong, toLong, includeMin, includeMax);
        }
        return null;
    }

    public static class DateRange
    extends Range<Date> {
        private final boolean _numeric;
        private final DateTools.Resolution _resolution;

        public DateRange(String f, Date from, Date to, boolean includeMin, boolean includeMax, boolean numeric, DateTools.Resolution res) {
            super(f, from, to, includeMin, includeMax);
            this._numeric = numeric;
            this._resolution = res;
        }

        @Override
        public String format(Date value) {
            return Dates.format((Date)value, (DateTools.Resolution)this._resolution);
        }

        @Override
        public String type() {
            return "date";
        }

        @Override
        public SearchParameter toParameter() {
            return new DateParameter(this._field, (Date)this._min, (Date)this._max, this._includeMin, this._includeMax, this._resolution, this._numeric);
        }

        @Override
        public FlexibleRangeFacet.Range toFacetRange() {
            return FlexibleRangeFacet.Range.dateRange((Date)((Date)this._min), (boolean)this._includeMin, (Date)((Date)this._max), (boolean)this._includeMax, (DateTools.Resolution)this._resolution);
        }
    }

    public static class NumberRange
    extends Range<Number> {
        public NumberRange(String f, Number min, Number max, boolean includeMin, boolean includeMax) {
            super(f, min, max, includeMin, includeMax);
        }

        @Override
        public String format(Number value) {
            return value.toString();
        }

        @Override
        public String type() {
            Number n = this._min != null ? (Number)((Number)this._min) : (Number)((Number)this._max);
            return n.getClass().getSimpleName().toLowerCase();
        }

        @Override
        public SearchParameter toParameter() {
            if (this._min != null && this._min instanceof Integer || this._max != null && this._max instanceof Integer) {
                return NumericRange.newIntRange((String)this._field, (Integer)((Integer)this._min), (Integer)((Integer)this._max), (boolean)this._includeMin, (boolean)this._includeMax);
            }
            if (this._min != null && this._min instanceof Float || this._max != null && this._max instanceof Float) {
                return NumericRange.newFloatRange((String)this._field, (Float)((Float)this._min), (Float)((Float)this._max), (boolean)this._includeMin, (boolean)this._includeMax);
            }
            if (this._min != null && this._min instanceof Double || this._max != null && this._max instanceof Double) {
                return NumericRange.newDoubleRange((String)this._field, (Double)((Double)this._min), (Double)((Double)this._max), (boolean)this._includeMin, (boolean)this._includeMax);
            }
            if (this._min != null && this._min instanceof Long || this._max != null && this._max instanceof Long) {
                return NumericRange.newLongRange((String)this._field, (Long)((Long)this._min), (Long)((Long)this._max), (boolean)this._includeMin, (boolean)this._includeMax);
            }
            return null;
        }

        @Override
        public FlexibleRangeFacet.Range toFacetRange() {
            return FlexibleRangeFacet.Range.numericRange((Number)((Number)this._min), (boolean)this._includeMin, (Number)((Number)this._max), (boolean)this._includeMax);
        }
    }

    public static class StringRange
    extends Range<String> {
        public StringRange(String f, String min, String max, boolean includeMin, boolean includeMax) {
            super(f, min, max, includeMin, includeMax);
        }

        @Override
        public String format(String value) {
            return value;
        }

        @Override
        public String type() {
            return "string";
        }

        @Override
        public SearchParameter toParameter() {
            return new SearchParameter(){

                @Deprecated
                public void toXML(XMLWriter xml) throws IOException {
                    XMLOutputPrinter out = new XMLOutputPrinter();
                    this.print((OutputPrinter)out);
                    xml.writeXML(out.toString());
                }

                public Query toQuery() {
                    BytesRef lower = _min == null ? null : new BytesRef((CharSequence)_min);
                    BytesRef upper = _max == null ? null : new BytesRef((CharSequence)_max);
                    return new TermRangeQuery(_field, lower, upper, _includeMin, _includeMax);
                }

                public boolean isEmpty() {
                    return _min == null && _max == null;
                }
            };
        }

        @Override
        public FlexibleRangeFacet.Range toFacetRange() {
            return FlexibleRangeFacet.Range.stringRange((String)((String)this._min), (boolean)this._includeMin, (String)((String)this._max), (boolean)this._includeMax);
        }
    }

    public static abstract class Range<T>
    implements UniversallyPrintable {
        final String _field;
        final T _min;
        final T _max;
        final boolean _includeMin;
        final boolean _includeMax;

        public Range(String field, T min, T max, boolean includeMin, boolean includeMax) {
            this._field = field;
            this._min = min;
            this._max = max;
            this._includeMin = includeMin;
            this._includeMax = includeMax;
        }

        public final String field() {
            return this._field;
        }

        public final T min() {
            return this._min;
        }

        public final T max() {
            return this._max;
        }

        public abstract SearchParameter toParameter();

        public abstract String format(T var1);

        public abstract String type();

        public abstract FlexibleRangeFacet.Range toFacetRange();

        public final void print(OutputPrinter out) {
            out.startObject("range");
            out.field("field", this._field);
            out.field("type", this.type());
            if (this._min != null) {
                out.field("min", this.format(this._min));
                out.field("min-included", this._includeMin);
            }
            if (this._max != null) {
                out.field("max", this.format(this._max));
                out.field("max-included", this._includeMax);
            }
            out.endObject();
        }

        public @NonNull String toString() {
            return this._field + ":" + (this._includeMin ? "[" : "{") + String.valueOf(this._min) + "-" + String.valueOf(this._max) + (this._includeMax ? (char)']' : '}');
        }
    }
}

