/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.queries;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.search.queries.Filters;
import com.pageseeder.search.queries.Ranges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.LuceneUtils;
import org.pageseeder.flint.lucene.query.Queries;
import org.pageseeder.flint.lucene.query.Question;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.search.DateTermFilter;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.search.NumericTermFilter;
import org.pageseeder.flint.lucene.search.StringTermFilter;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PageSeederQuery
implements SearchQuery,
UniversallyPrintable {
    private final Question _question;
    private final List<Filter> _filters;
    private final List<Ranges.Range> _ranges;
    private final Sort _sort;
    private final Analyzer _analyser;
    private final Query _baseQuery;
    private final Query _query;
    private final Query _customFilter;
    private final boolean _customFilterAnd;

    private PageSeederQuery(String predicate, String defaultfield, Analyzer analyser, Question question, List<Filter> filters, List<Ranges.Range> ranges, Query customFilter, boolean customFilterAnd, Sort sort) throws ParseException {
        Query base;
        if (predicate == null && question == null) {
            throw new NullPointerException("predicate or question");
        }
        if (predicate != null && defaultfield == null) {
            throw new NullPointerException("defaultfield");
        }
        if (predicate != null && analyser == null) {
            throw new NullPointerException("analyser");
        }
        if (filters == null) {
            throw new NullPointerException("filters");
        }
        if (ranges == null) {
            throw new NullPointerException("ranges");
        }
        if (sort == null) {
            throw new NullPointerException("sort");
        }
        this._question = question;
        this._analyser = analyser;
        this._filters = filters;
        this._sort = sort;
        this._ranges = ranges;
        this._customFilter = customFilter;
        this._customFilterAnd = customFilterAnd;
        Query query = base = predicate != null ? PageSeederQuery.toPredicateQuery(predicate, defaultfield, analyser) : question.toQuery();
        if (base == null) {
            base = new MatchAllDocsQuery();
        }
        this._baseQuery = PageSeederQuery.applyRanges(base, ranges);
        Query q = PageSeederQuery.applyFilters(this._baseQuery, filters);
        if (this._customFilter != null) {
            q = customFilterAnd ? Queries.and((Query[])new Query[]{q, this._customFilter}) : Queries.or((Query[])new Query[]{q, this._customFilter});
        }
        this._query = q;
    }

    public Question question() {
        return this._question;
    }

    public Sort getSort() {
        return this._sort;
    }

    public boolean isEmpty() {
        return this._query == null;
    }

    public Query toQuery() {
        return this._query;
    }

    public Query getBaseQuery() {
        return this._baseQuery;
    }

    public List<Filter> getFilters() {
        return this._filters;
    }

    public String toString() {
        return this._query.toString();
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("query", true);
        xml.attribute("empty", Boolean.toString(this.isEmpty()));
        if (!this.isEmpty()) {
            String predicate = this._query.toString();
            xml.attribute("predicate", predicate);
            if (this._question != null) {
                xml.openElement("question", true);
                xml.attribute("empty", Boolean.toString(this._question.isEmpty()));
                if (this.stopWordsOnly()) {
                    xml.attribute("stop-words-only", "true");
                }
                for (String field : this._question.fields()) {
                    xml.openElement("field");
                    Float boost = Float.valueOf(this._question.getBoost(field));
                    xml.attribute("boost", boost != null ? boost.toString() : "1.0");
                    xml.attribute("name", field);
                    xml.closeElement();
                }
                xml.element("text", this._question.question());
                xml.closeElement();
            }
            if (this._filters != null && !this._filters.isEmpty()) {
                xml.openElement("filters", true);
                for (Filter f : this._filters) {
                    f.toXML(xml);
                }
                xml.closeElement();
            }
            Ranges.toXML(this._ranges, xml);
            xml.openElement("sort", this._sort != Sort.RELEVANCE);
            if (this._sort == Sort.RELEVANCE) {
                xml.attribute("by", "relevance");
            } else {
                xml.attribute("by", "fields");
                for (Iterator<Object> iterator : this._sort.getSort()) {
                    xml.openElement("sortfield");
                    xml.attribute("field", iterator.getField());
                    xml.attribute("type", iterator.getType().name());
                    xml.attribute("reverse", Boolean.toString(iterator.getReverse()));
                    xml.closeElement();
                }
            }
            xml.closeElement();
        }
        xml.closeElement();
    }

    public void print(OutputPrinter out) {
        out.startObject("query");
        out.field("empty", this.isEmpty());
        if (!this.isEmpty()) {
            String predicate = this._query.toString();
            out.field("predicate", predicate);
            if (this._question != null) {
                out.startObject("question");
                out.field("empty", this._question.isEmpty());
                if (this.stopWordsOnly()) {
                    out.field("stop-words-only", true);
                }
                out.startCollection("fields", OutputPrinter.CollectionOption.JSON_ONLY);
                for (String field : this._question.fields()) {
                    out.startObject("field");
                    Float boost = Float.valueOf(this._question.getBoost(field));
                    out.field("boost", boost != null ? boost.toString() : "1.0");
                    out.field("name", field);
                    out.endObject();
                }
                out.endCollection();
                out.field("text", this._question.question(), OutputPrinter.FieldOption.XML_ELEMENT);
                out.endObject();
            }
            if (this._filters != null && !this._filters.isEmpty()) {
                out.startCollection("filters");
                for (Filter f : this._filters) {
                    Filters.print(f, out);
                }
                out.endCollection();
            }
            Ranges.print(this._ranges, out);
            out.startObject("sort", this._sort == Sort.RELEVANCE ? OutputPrinter.ObjectOption.XML_EMPTY : OutputPrinter.ObjectOption.DEFAULT);
            if (this._sort == Sort.RELEVANCE) {
                out.field("by", "relevance");
            } else {
                out.field("by", "fields");
                out.startCollection("sortfields", OutputPrinter.CollectionOption.JSON_ONLY);
                for (Iterator<Object> iterator : this._sort.getSort()) {
                    out.startObject("sortfield");
                    out.field("field", iterator.getField());
                    out.field("type", iterator.getType().name());
                    out.field("reverse", iterator.getReverse());
                    out.endObject();
                }
                out.endCollection();
            }
            out.endObject();
        }
        out.endObject();
    }

    public PageSeederQuery newQuery(Question question) {
        try {
            return new PageSeederQuery(null, null, this._analyser, question, this._filters, this._ranges, this._customFilter, this._customFilterAnd, this._sort);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public PageSeederQuery newQuery(List<Filter> filters) {
        try {
            ArrayList<Filter> newFilters = new ArrayList<Filter>(this._filters);
            newFilters.addAll(filters);
            return new PageSeederQuery(null, null, this._analyser, this._question, newFilters, this._ranges, this._customFilter, this._customFilterAnd, this._sort);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public Analyzer getAnalyser() {
        return this._analyser;
    }

    private static Query toPredicateQuery(String predicate, String defaultfield, Analyzer analyser) throws ParseException {
        if (predicate == null) {
            return null;
        }
        QueryParser parser = new QueryParser(defaultfield, analyser);
        parser.setAllowLeadingWildcard(true);
        return parser.parse(predicate);
    }

    private static Query applyRanges(Query query, List<Ranges.Range> ranges) {
        if (ranges != null && !ranges.isEmpty()) {
            BooleanQuery.Builder fq = new BooleanQuery.Builder();
            for (Ranges.Range range : ranges) {
                fq.add(range.toParameter().toQuery(), BooleanClause.Occur.MUST);
            }
            return query == null ? fq.build() : Queries.and((Query[])new Query[]{query, fq.build()});
        }
        return query;
    }

    private static Query applyFilters(Query query, List<Filter> filters) {
        Query newQuery = query;
        if (filters != null) {
            for (Filter filter : filters) {
                newQuery = filter.filterQuery(newQuery);
            }
        }
        return newQuery;
    }

    private boolean stopWordsOnly() {
        if (this._question != null && !this._question.isEmpty()) {
            for (String field : this._question.fields()) {
                if (!Fields.toTerms((String)field, (String)this._question.question(), (Analyzer)this._analyser).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static final class Builder {
        private String _predicate = null;
        private String _defaultfield = null;
        private Catalog _catalog = null;
        private Analyzer _analyser = null;
        private String _question = null;
        private Query _customFilter = null;
        private boolean _customFilterAnd = true;
        private boolean _questionDefaultOperatorOR = false;
        private final List<String> _fields = new ArrayList<String>();
        private final List<Ranges.Range> _ranges = new ArrayList<Ranges.Range>();
        private final Map<String, StringTermFilter.Builder> _stringFilters = new HashMap<String, StringTermFilter.Builder>();
        private final Map<String, NumericTermFilter.Builder> _numericFilters = new HashMap<String, NumericTermFilter.Builder>();
        private final Map<String, DateTermFilter.Builder> _dateFilters = new HashMap<String, DateTermFilter.Builder>();
        private List<SortField> _sort = null;

        public Builder predicate(String predicate) {
            this._predicate = predicate;
            return this;
        }

        public Builder defaultField(String defaultField) {
            this._defaultfield = defaultField;
            return this;
        }

        public Builder analyser(Analyzer analyser) {
            this._analyser = analyser;
            return this;
        }

        public Builder catalog(Catalog catalog) {
            this._catalog = catalog;
            return this;
        }

        public Builder question(String question) {
            this._question = question;
            return this;
        }

        public Builder customFilter(Query filter, boolean and) {
            this._customFilter = filter;
            this._customFilterAnd = and;
            return this;
        }

        public Builder questionDefaultOperatorOR(boolean questionDefaultOperatorOR) {
            this._questionDefaultOperatorOR = questionDefaultOperatorOR;
            return this;
        }

        public Builder addRange(Ranges.Range range) {
            if (range != null) {
                this._ranges.add(range);
            }
            return this;
        }

        public Builder addSetSortField(String field, boolean reverse) {
            if (Fields.isValidName((String)field)) {
                if (this._sort == null) {
                    this._sort = new ArrayList<SortField>();
                }
                this._sort.add((SortField)new SortedSetSortField(field, reverse));
            }
            return this;
        }

        public Builder addSortField(String field, SortField.Type type, boolean reverse) {
            if (Fields.isValidName((String)field)) {
                if (this._sort == null) {
                    this._sort = new ArrayList<SortField>();
                }
                this._sort.add(new SortField(field, type, reverse));
            }
            return this;
        }

        public Builder addNumericSortField(String field, SortField.Type type, boolean reverse) {
            if (Fields.isValidName((String)field)) {
                if (this._sort == null) {
                    this._sort = new ArrayList<SortField>();
                }
                this._sort.add((SortField)new SortedNumericSortField(field, type, reverse));
            }
            return this;
        }

        public Builder addSearchField(String field) {
            this._fields.add(field);
            return this;
        }

        public Builder addStringFilter(String field, String value, BooleanClause.Occur occurrence) {
            if (field == null || value == null) {
                return this;
            }
            StringTermFilter.Builder f = this._stringFilters.get(field);
            if (f == null) {
                this._stringFilters.put(field, new StringTermFilter.Builder().name(field).addTerm(value, occurrence));
            } else {
                f.addTerm(value, occurrence);
            }
            return this;
        }

        public Builder addNumericFilter(String field, Number value, FlintField.NumericType numeric, BooleanClause.Occur occurrence) {
            if (field == null || value == null) {
                return this;
            }
            NumericTermFilter.Builder f = this._numericFilters.get(field);
            if (f == null) {
                this._numericFilters.put(field, new NumericTermFilter.Builder().numeric(numeric).name(field).addNumber(value, occurrence));
            } else {
                f.addNumber(value, occurrence);
            }
            return this;
        }

        public Builder addDateFilter(String field, Date value, FlintField.Resolution res, BooleanClause.Occur occurrence) {
            if (field == null) {
                return this;
            }
            DateTermFilter.Builder f = this._dateFilters.get(field);
            if (f == null) {
                this._dateFilters.put(field, new DateTermFilter.Builder().name(field).resolution(LuceneUtils.toResolution((FlintField.Resolution)res)).addDate(value, occurrence));
            } else {
                f.addDate(value, occurrence);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public PageSeederQuery build() throws ParseException {
            void var4_11;
            if (this._analyser == null) {
                throw new NullPointerException("analyser");
            }
            if (this._predicate == null && this._question == null) {
                throw new NullPointerException("predicate and question");
            }
            Question q = this._predicate == null ? new Question.Builder().fields(Fields.asBoostMap(this._fields)).question(this._question).analyzerAndCatalog(this._analyser, this._catalog).defaultOperatorOR(this._questionDefaultOperatorOR).supportWildcards(true).build() : null;
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (StringTermFilter.Builder builder : this._stringFilters.values()) {
                filters.add((Filter)builder.build());
            }
            for (NumericTermFilter.Builder builder : this._numericFilters.values()) {
                filters.add((Filter)builder.build());
            }
            for (DateTermFilter.Builder builder : this._dateFilters.values()) {
                filters.add((Filter)builder.build());
            }
            Sort sort = Sort.RELEVANCE;
            if (this._sort != null && !this._sort.isEmpty()) {
                sort = new Sort(this._sort.toArray(new SortField[0]));
            }
            if (!this._ranges.isEmpty()) {
                List<Ranges.Range> list = Collections.unmodifiableList(new ArrayList<Ranges.Range>(this._ranges));
            } else {
                List list = Collections.emptyList();
            }
            return new PageSeederQuery(this._predicate, this._defaultfield, this._analyser, q, filters, (List<Ranges.Range>)var4_11, this._customFilter, this._customFilterAnd, sort);
        }
    }
}

