/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.queries;

import com.pageseeder.common.util.Strings;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.DateTools;
import org.eclipse.jdt.annotation.NonNull;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.LuceneUtils;
import org.pageseeder.flint.lucene.facet.DateIntervalFacet;
import org.pageseeder.flint.lucene.facet.FlexibleIntervalFacet;
import org.pageseeder.flint.lucene.facet.NumericIntervalFacet;
import org.pageseeder.flint.lucene.facet.StringIntervalFacet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Intervals {
    private static final Logger LOGGER = LoggerFactory.getLogger(Intervals.class);
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("(.+):(\\[|\\{)(.{1,500})(\\]|\\})");
    private static final String NUMBER_PATTERN = "\\d+";
    private static final String FLOAT_PATTERN = "\\d+\\.\\d+";

    public static boolean isInterval(String string) {
        return Intervals.isInterval(string, null);
    }

    public static boolean isInterval(String string, Catalog catalog) {
        return Intervals.createInterval(string, catalog) != null;
    }

    public static Interval createInterval(String string, Catalog catalog) {
        String end;
        if (string == null) {
            return null;
        }
        Matcher matcher = INTERVAL_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String field = matcher.group(1);
        boolean includeMin = "[".equals(matcher.group(2));
        boolean includeMax = "]".equals(matcher.group(4));
        String[] split1 = Strings.split((String)matcher.group(3), (char)'|', (char)'\\', (boolean)false);
        if (split1 == null || split1.length != 2) {
            return null;
        }
        String interval = split1[1];
        if (interval.isEmpty() || interval.equals("0") || interval.charAt(0) == '-') {
            return null;
        }
        String[] split2 = Strings.split((String)split1[0], (char)';', (char)'\\');
        if (split2 == null || split2.length < 1 || split2.length > 2) {
            return null;
        }
        String start = split2[0];
        String string2 = end = split2.length == 2 ? split2[1] : null;
        if (start.isEmpty() && end == null) {
            return null;
        }
        if (start.equals(end)) {
            return null;
        }
        if (catalog != null) {
            return Intervals.createCatalogInterval(catalog, field, start, end, interval, includeMin, includeMax);
        }
        return Intervals.createFallbackInterval(field, start, end, interval, includeMin, includeMax);
    }

    private static Interval createCatalogInterval(Catalog catalog, String field, String start, String end, String interval, boolean includeMin, boolean includeMax) {
        FlintField.NumericType num = catalog.getNumericType(field);
        if (num != null) {
            return Intervals.createNumberInterval(field, start, end, interval, includeMin, includeMax, num);
        }
        DateTools.Resolution res = LuceneUtils.toResolution((FlintField.Resolution)catalog.getResolution(field));
        if (res != null) {
            return Intervals.createDateInterval(field, start, end, interval, includeMin, includeMax, res);
        }
        return Intervals.createFallbackInterval(field, start, end, interval, includeMin, includeMax);
    }

    private static Interval createFallbackInterval(String field, String start, String end, String interval, boolean includeMin, boolean includeMax) {
        DateInterval dateInterval = Intervals.createDateInterval(field, start, end, interval, includeMin, includeMax, null);
        if (dateInterval != null) {
            return dateInterval;
        }
        NumberInterval numberInterval = Intervals.createNumberInterval(field, start, end, interval, includeMin, includeMax, null);
        if (numberInterval != null) {
            return numberInterval;
        }
        if (end != null && start.compareTo(end) >= 0) {
            return null;
        }
        try {
            int length = Integer.parseInt(interval);
            return new StringInterval(field, start, end, length, includeMin, includeMax);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Invalid interval length {}", (Object)interval);
            return null;
        }
    }

    private static DateInterval createDateInterval(String field, String start, String end, String interval, boolean includeMin, boolean includeMax, DateTools.Resolution resolution) {
        Duration duration;
        OffsetDateTime startDate;
        OffsetDateTime endDate = null;
        try {
            startDate = OffsetDateTime.parse(start);
            if (end != null) {
                endDate = OffsetDateTime.parse(end);
            }
        }
        catch (DateTimeParseException ex) {
            return null;
        }
        Period period = null;
        try {
            duration = Duration.parse("P" + interval.toUpperCase());
        }
        catch (DateTimeParseException ex) {
            duration = null;
        }
        if (duration == null) {
            try {
                period = Period.parse("P" + interval.toUpperCase());
            }
            catch (DateTimeParseException ex) {
                return null;
            }
        }
        return new DateInterval(field, startDate, endDate, period, duration, includeMin, includeMax, resolution == null ? DateTools.Resolution.SECOND : resolution);
    }

    private static NumberInterval createNumberInterval(String field, String start, String end, String interval, boolean includeMin, boolean includeMax, FlintField.NumericType num) {
        if (start == null || start.isEmpty() || end == null || end.isEmpty() || interval == null || interval.isEmpty()) {
            return null;
        }
        Float from = null;
        Float to = null;
        Float length = null;
        if (start.matches(FLOAT_PATTERN)) {
            from = Float.valueOf(Float.parseFloat(start));
        }
        if (end.matches(FLOAT_PATTERN)) {
            to = Float.valueOf(Float.parseFloat(end));
        }
        if (interval.matches(FLOAT_PATTERN)) {
            length = Float.valueOf(Float.parseFloat(interval));
        }
        if (from != null || to != null || length != null) {
            if (num != FlintField.NumericType.FLOAT && num != FlintField.NumericType.DOUBLE) {
                LOGGER.warn("Wrong numeric type float for interval");
                return null;
            }
            if (from == null && start.matches(NUMBER_PATTERN)) {
                from = Float.valueOf(Float.parseFloat(start));
            }
            if (to == null && end.matches(NUMBER_PATTERN)) {
                to = Float.valueOf(Float.parseFloat(end));
            }
            if (length == null && interval.matches(NUMBER_PATTERN)) {
                length = Float.valueOf(Float.parseFloat(interval));
            }
            if (from == null || to == null || length == null || from.floatValue() >= to.floatValue()) {
                return null;
            }
            return new NumberInterval(field, from, to, length, includeMin, includeMax, num);
        }
        Long fromLong = null;
        Long toLong = null;
        Long lengthLong = null;
        if (start.matches(NUMBER_PATTERN)) {
            fromLong = Long.parseLong(start);
        }
        if (end.matches(NUMBER_PATTERN)) {
            toLong = Long.parseLong(end);
        }
        if (interval.matches(NUMBER_PATTERN)) {
            lengthLong = Long.parseLong(interval);
        }
        if (fromLong == null || toLong == null || lengthLong == null || fromLong >= toLong) {
            return null;
        }
        return new NumberInterval(field, fromLong, toLong, lengthLong, includeMin, includeMax, num == null ? FlintField.NumericType.LONG : num);
    }

    public static class NumberInterval
    extends Interval {
        private final Number _start;
        private final Number _end;
        private final Number _length;
        private final boolean _withMin;
        private final boolean _withMax;
        private final FlintField.NumericType _num;

        public NumberInterval(String f, Number start, Number end, Number l, boolean includeMin, boolean includeMax, FlintField.NumericType num) {
            super(f);
            this._start = start;
            this._end = end;
            this._length = l;
            this._withMin = includeMin;
            this._withMax = includeMax;
            this._num = num;
        }

        @Override
        public FlexibleIntervalFacet toFacet() {
            return new NumericIntervalFacet.Builder().name(this._field).includeLastMax(this._withMax).includeMin(this._withMin).start(this._start).end(this._end).intervalLength(this._length).numeric(this._num).build();
        }

        public @NonNull String toString() {
            return this._field + ":" + (this._withMin ? "[" : "{") + String.valueOf(this._start) + (String)(this._end != null ? ";" + String.valueOf(this._end) : "") + "|" + String.valueOf(this._length) + (this._withMax ? (char)']' : '}');
        }
    }

    public static class DateInterval
    extends Interval {
        private final OffsetDateTime _start;
        private final OffsetDateTime _end;
        private final Period _period;
        private final Duration _duration;
        private final boolean _withMin;
        private final boolean _withMax;
        private final DateTools.Resolution _resolution;

        public DateInterval(String f, OffsetDateTime start, OffsetDateTime end, Period period, Duration dur, boolean includeMin, boolean includeMax, DateTools.Resolution res) {
            super(f);
            this._start = start;
            this._end = end;
            this._period = period;
            this._duration = dur;
            this._withMin = includeMin;
            this._withMax = includeMax;
            this._resolution = res;
        }

        @Override
        public FlexibleIntervalFacet toFacet() {
            return new DateIntervalFacet.Builder().name(this._field).includeLastMax(this._withMax).includeMin(this._withMin).resolution(this._resolution).start(this._start).end(this._end).intervalDate(this._period).intervalTime(this._duration).build();
        }

        public @NonNull String toString() {
            return this._field + ":" + (this._withMin ? "[" : "{") + String.valueOf(this._start) + (String)(this._end != null ? ";" + String.valueOf(this._end) : "") + "|" + String.valueOf(this._period == null ? "" : this._period) + "-" + String.valueOf(this._duration == null ? "" : this._duration) + (this._withMax ? (char)']' : '}');
        }
    }

    public static class StringInterval
    extends Interval {
        private final String _start;
        private final String _end;
        private final int _length;
        private final boolean _withMin;
        private final boolean _withMax;

        public StringInterval(String f, String s, String e, int l, boolean is, boolean ie) {
            super(f);
            this._start = s;
            this._end = e;
            this._length = l;
            this._withMin = is;
            this._withMax = ie;
        }

        @Override
        public FlexibleIntervalFacet toFacet() {
            return new StringIntervalFacet.Builder().name(this._field).start(this._start).end(this._end).intervalLength(this._length).includeLastMax(this._withMax).includeMin(this._withMin).build();
        }

        public @NonNull String toString() {
            return this._field + ":" + (this._withMin ? (char)'[' : '{') + this._start + (String)(this._end != null ? ";" + this._end : "") + "|" + this._length + (this._withMax ? (char)']' : '}');
        }
    }

    public static abstract class Interval {
        protected final String _field;

        public Interval(String field) {
            this._field = field;
        }

        public abstract FlexibleIntervalFacet toFacet();
    }
}

