/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.queries;

import com.pageseeder.base.serial.OutputPrinter;
import java.time.OffsetDateTime;
import java.util.Map;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.BooleanClause;
import org.pageseeder.flint.lucene.search.DateTermFilter;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.search.NumericTermFilter;
import org.pageseeder.flint.lucene.search.StringTermFilter;
import org.pageseeder.flint.lucene.util.Dates;

public class Filters {
    public static void print(Filter filter, OutputPrinter out) {
        if (filter instanceof StringTermFilter) {
            Filters.printStringFilter((StringTermFilter)filter, out);
        } else if (filter instanceof NumericTermFilter) {
            Filters.printNumericFilter((NumericTermFilter)filter, out);
        } else if (filter instanceof DateTermFilter) {
            Filters.printDateFilter((DateTermFilter)filter, out);
        } else {
            out.startObject("filter");
            out.field("field", filter.name());
            out.field("type", "unknown");
            out.endObject();
        }
    }

    private static void printStringFilter(StringTermFilter filter, OutputPrinter out) {
        out.startObject("filter");
        out.field("field", filter.name());
        out.field("type", "string");
        out.startCollection("terms", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Map.Entry term : filter.terms().entrySet()) {
            out.startObject("term");
            out.field("text", (String)term.getKey());
            out.field("occur", Filters.occurToString((BooleanClause.Occur)term.getValue()));
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }

    private static void printNumericFilter(NumericTermFilter filter, OutputPrinter out) {
        out.startObject("filter");
        out.field("field", filter.name());
        out.field("type", "numeric");
        out.startCollection("terms", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Map.Entry term : filter.terms().entrySet()) {
            out.startObject("term");
            out.field("text", ((Number)term.getKey()).toString());
            out.field("occur", Filters.occurToString((BooleanClause.Occur)term.getValue()));
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }

    private static void printDateFilter(DateTermFilter filter, OutputPrinter out) {
        out.startObject("filter");
        out.field("field", filter.name());
        out.field("type", "date");
        out.startCollection("terms", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Map.Entry term : filter.terms().entrySet()) {
            out.startObject("term");
            out.field("text", Dates.toString((OffsetDateTime)((OffsetDateTime)term.getKey()), (DateTools.Resolution)filter.getResolution()));
            out.field("date", Dates.format((OffsetDateTime)((OffsetDateTime)term.getKey()), (DateTools.Resolution)filter.getResolution()));
            out.field("occur", Filters.occurToString((BooleanClause.Occur)term.getValue()));
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }

    private static String occurToString(BooleanClause.Occur occur) {
        if (occur == BooleanClause.Occur.MUST) {
            return "must";
        }
        if (occur == BooleanClause.Occur.MUST_NOT) {
            return "must_not";
        }
        if (occur == BooleanClause.Occur.SHOULD) {
            return "should";
        }
        return "unknown";
    }
}

