/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.help;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.PSHelpContent;
import com.pageseeder.search.flint.PSRequester;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.indexing.IndexBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HelpIndexingThread
extends ProcessThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelpIndexingThread.class);
    private boolean clearFirst = false;
    private int total = 0;
    private int alreadyDone = 0;
    private final IndexBatch batch = new IndexBatch("help/help/Indexing help content");
    private final PSRequester requester = new PSRequester("Indexing help content");

    private HelpIndexingThread(String username) {
        super(username, "Help content indexing", null);
    }

    public void setClearFirst(boolean clear) {
        this.clearFirst = clear;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        try {
            Catalog helpCat;
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing objects to index");
            List<String> documents = HelpIndexingThread.listPSMLFiles(PSHelpContent.CONTENT_ROOT.toPath());
            this.total = documents.size() + (this.clearFirst ? 1 : 0);
            this.batch.increaseTotal(this.total);
            this.batch.setComputed();
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + documents.size() + " documents to index");
            if (documents.isEmpty()) {
                this.complete("Nothing to index!");
                return;
            }
            IndexMaster master = IndexMaster.getInstance();
            if (this.clearFirst) {
                master.clearHelpIndex(this.batch, this.requester);
            }
            if ((helpCat = Catalogs.getCatalog((String)"help")) != null) {
                helpCat.clear();
            }
            for (String path : documents) {
                master.indexHelpDocument(path, this.batch, this.requester);
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Added " + path + " to indexing queue");
                ++this.alreadyDone;
            }
        }
        finally {
            this.complete("Finished adding objects to the indexing queue");
        }
    }

    public static HelpIndexingThread newInstance(String username) {
        return new HelpIndexingThread(username);
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("indexing");
        out.startObject("progress");
        out.field("current", (long)this.alreadyDone);
        out.field("total", (long)this.total);
        out.endObject();
        out.endObject();
    }

    public static List<String> listPSMLFiles(final Path root) {
        final ArrayList<String> relativePaths = new ArrayList<String>();
        try {
            final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:*.psml");
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                final int from;
                {
                    this.from = root.toString().length() + 1;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Path name = file.getFileName();
                    if (name != null && matcher.matches(name)) {
                        relativePaths.add(file.toString().substring(this.from).replace('\\', '/'));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            LOGGER.error("Unable to retrieve list of PSML help files to index: {}", (Object)ex.getMessage(), (Object)ex);
        }
        return relativePaths;
    }
}

