/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint.log;

import com.pageseeder.base.logback.XLoggable;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.xml.XMLUtils;
import com.pageseeder.search.GroupIndexReindexing;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSContentType;
import com.pageseeder.search.flint.PSRequester;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.indexing.IndexBatch;
import org.pageseeder.flint.indexing.IndexJob;
import org.pageseeder.flint.indexing.IndexListener;

public final class PSIndexListener
extends XLoggerAdaptor
implements IndexListener {
    public PSIndexListener() {
        super("Index");
    }

    public void warn(IndexJob job, String msg) {
        this.warn(new IndexEvent(EventType.INDEX, job, msg));
    }

    public void error(IndexJob job, String msg, Throwable throwable) {
        if (throwable instanceof IndexException && throwable.getCause() != null && throwable.getCause() instanceof TransformerException) {
            this.error(new IndexEvent(EventType.INDEX, job, msg), throwable.getCause());
        } else {
            this.error(new IndexEvent(EventType.INDEX, job, msg), throwable);
        }
    }

    public void endJob(IndexJob job) {
        if (job.wasSuccessful()) {
            if (job.getContentType() != PSContentType.TASK) {
                this.info(new IndexEvent(EventType.COMPLETE, job));
            }
        } else {
            this.error(new IndexEvent(EventType.FAIL, job));
        }
    }

    public void startJob(IndexJob job) {
        if (job.getContentType() != PSContentType.TASK) {
            this.info(new IndexEvent(EventType.START, job));
        }
    }

    public void startBatch(IndexBatch batch) {
        this.info(new IndexEvent(EventType.START, batch));
    }

    public void endBatch(IndexBatch batch) {
        this.info(new IndexEvent(EventType.COMPLETE, batch));
        String[] parts = batch.getIndex().split("/");
        if (parts.length != 0 && parts[0].matches("^\\d+$")) {
            Long groupid = Long.parseLong(parts[0]);
            if (GroupIndexReindexing.isReindexingBatch(groupid, batch.getID())) {
                IndexMaster master = IndexMaster.getInstance();
                if (GroupIndexReindexing.stopReindexing(groupid)) {
                    master.closeIndex(groupid);
                }
                Catalogs.save((String)master.getCatalog(groupid));
            }
        } else if (parts.length != 0 && "help".equals(parts[0])) {
            Catalogs.save((String)"help");
        }
    }

    private static String toGroupID(IndexJob job, IndexBatch batch) {
        return batch != null && batch.getIndex() != null && (batch.getIndex().startsWith("help/") || batch.getIndex().equals("help")) ? null : (batch != null && batch.getIndex() != null && (batch.getIndex().startsWith("urls/") || batch.getIndex().equals("urls")) ? null : (batch != null && batch.getIndex() != null ? batch.getIndex().split("/")[0] : (batch != null ? null : (job != null && "help".equals(job.getIndex().getIndexID()) ? null : (job != null && "urls".equals(job.getIndex().getIndexID()) ? null : (job != null ? job.getIndex().getIndexID() : null))))));
    }

    private static final class IndexEvent
    implements XLoggable {
        private final EventType _type;
        private final IndexJob _job;
        private final IndexBatch _batch;
        private final String _message;

        public IndexEvent(EventType type, IndexBatch batch) {
            this._type = type;
            this._job = null;
            this._batch = batch;
            this._message = null;
        }

        public IndexEvent(EventType type, IndexJob job) {
            this._type = type;
            this._job = job;
            this._batch = null;
            this._message = null;
        }

        public IndexEvent(EventType type, IndexJob job, String message) {
            this._type = type;
            this._job = job;
            this._batch = null;
            this._message = message;
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("[").append(this._type.toString()).append(']');
            if (this._message != null) {
                out.append(" - ").append(this._message);
            }
            if (this._job != null) {
                out.append(" Requester=").append(this._job.getRequester().getRequesterID());
                out.append(" Index=").append(this._job.getIndex().getIndexID());
                out.append('/').append(((PSRequester)this._job.getRequester()).groupName());
                out.append(" Content=").append(IndexEvent.getContentID(this._job));
                out.append('/').append(this._job.getContentType().toString());
            } else if (this._batch != null) {
                out.append(" Batch=").append(this._batch.getID());
                if (this._batch.getIndex() != null) {
                    out.append(" Index=").append(this._batch.getIndex());
                }
                out.append(" Documents=").append(this._batch.getTotalDocuments());
                out.append(" Duration=").append(this._batch.getTotalDuration());
            }
            return out.toString();
        }

        public void toXMLLog(Appendable xml) throws IOException {
            xml.append("<job");
            xml.append(" type=\"").append(this._type.toString()).append('\"');
            if (this._job != null) {
                IndexEvent.attribute(xml, "process", this._job.getRequester().getRequesterID());
                if (this._job.getBatch() != null) {
                    IndexEvent.attribute(xml, "batch", this._job.getBatch().getID());
                }
                IndexEvent.attribute(xml, "index", this._job.getIndex().getIndexID());
                IndexEvent.attribute(xml, "contenttype", this._job.getContentType().toString());
                IndexEvent.attribute(xml, "contentid", IndexEvent.getContentID(this._job));
            } else if (this._batch != null) {
                IndexEvent.attribute(xml, "batch", this._batch.getID());
                IndexEvent.attribute(xml, "created", ISO8601.DATETIME.format(this._batch.getCreation().getTime()));
                IndexEvent.attribute(xml, "started", ISO8601.DATETIME.format(this._batch.getStart().getTime()));
                IndexEvent.attribute(xml, "computing", String.valueOf(this._batch.getComputingDuration()));
                IndexEvent.attribute(xml, "indexing", String.valueOf(this._batch.getIndexingDuration()));
                IndexEvent.attribute(xml, "documents", String.valueOf(this._batch.getTotalDocuments()));
                IndexEvent.attribute(xml, "total", String.valueOf(this._batch.getTotalDuration()));
            }
            if (this._message != null) {
                xml.append('>').append(XMLUtils.escapeText((String)this._message)).append("</job>");
            } else {
                xml.append(" />");
            }
        }

        public Long getGroupID() {
            String id = PSIndexListener.toGroupID(this._job, this._batch);
            return id != null ? Long.valueOf(id) : null;
        }

        public String getGroup() {
            if (this._batch != null) {
                String[] parts;
                if (this._batch.getIndex() != null && this._batch.getIndex().indexOf(47) > 0 && (parts = this._batch.getIndex().split("/")).length > 1 && !"help".startsWith(parts[1]) && !"urls".startsWith(parts[1])) {
                    return parts[1];
                }
                return null;
            }
            return this._job == null ? null : ((PSRequester)this._job.getRequester()).groupName();
        }

        public String getTicket() {
            if (this._batch != null) {
                return this._batch.getID();
            }
            if (this._job == null) {
                return null;
            }
            if (this._job.getBatch() != null) {
                return this._job.getBatch().getID();
            }
            return this._job.getRequester().getRequesterID();
        }

        public String getUser() {
            return null;
        }

        public String getTitle() {
            if (this._batch != null) {
                String[] parts;
                if (this._batch.getIndex() != null && this._batch.getIndex().indexOf(47) > 0 && (parts = this._batch.getIndex().split("/")).length > 1) {
                    return parts[2];
                }
                return "Batch Indexing";
            }
            return this._job == null ? null : ((PSRequester)this._job.getRequester()).process();
        }

        public XLoggable.TYPE getType() {
            if (this._job != null && this._job.isBatch()) {
                return null;
            }
            return this._type == EventType.START ? XLoggable.TYPE.START : (this._type == EventType.COMPLETE || this._type == EventType.FAIL ? XLoggable.TYPE.END : null);
        }

        private static void attribute(Appendable xml, String name, String value) throws IOException {
            xml.append(' ');
            xml.append(name).append('=').append('\"');
            xml.append(XMLUtils.escapeAttValue((String)value));
            xml.append('\"');
        }

        private static String getContentID(IndexJob job) {
            Long[] ids;
            if ("help".equals(job.getIndex().getIndexID())) {
                return job.getContentID();
            }
            ContentType ctype = job.getContentType();
            if ((ctype == PSContentType.URL || ctype == PSContentType.FOLDER || ctype == PSContentType.DOCUMENT) && (ids = IndexUtils.getURIContentIDs(job.getContentID())) != null) {
                return String.valueOf(ids[0]);
            }
            Long id = IndexUtils.getCommentContentID(job.getContentID());
            return id == null ? job.getContentID() : String.valueOf(id);
        }
    }

    private static enum EventType {
        START,
        INDEX,
        COMPLETE,
        FAIL;

    }
}

