/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint.log;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.TicketLog;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.log.PSIndexListener;
import java.io.IOException;
import java.text.ParseException;
import org.pageseeder.flint.indexing.IndexListener;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(parameters={"ticket"})
public final class GetTicketLog
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if ("true".equals(req.getParameter((Parameter)StandardParameters.allgroups))) {
            return new AdminSystemCheck();
        }
        return new EditURICheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) {
        boolean allgroups = "true".equals(req.getParameter((Parameter)StandardParameters.allgroups));
        String ticket = req.getParameter((Parameter)StandardParameters.ticket);
        String date = req.getParameter((Parameter)StandardParameters.date);
        boolean singleDay = req.getParameter((Parameter)StandardParameters.single_day, true);
        boolean includeInfo = req.getParameter((Parameter)StandardParameters.include_info, true);
        String[] includeTypes = req.getParameter((Parameter)StandardParameters.include_types, "").split(",");
        long page = req.getParameter((Parameter)StandardParameters.page, -1L);
        long pagesize = req.getParameter((Parameter)StandardParameters.pagesize, -1L);
        try {
            IndexMaster master = IndexMaster.getInstance();
            IndexListener listener = master.getListener();
            if (!(listener instanceof PSIndexListener)) {
                return;
            }
            PSIndexListener indexLogger = (PSIndexListener)listener;
            TicketLog log = new TicketLog((XLoggerAdaptor)indexLogger, ticket, allgroups || req.getGroup() == null ? null : req.getGroup().getId(), null);
            if (!includeInfo) {
                log.addExcludeType("INFO");
            }
            for (String type : includeTypes) {
                if (type.isEmpty()) continue;
                log.addIncludeType(type);
            }
            log.setMultipleDays(!singleDay);
            log.serSingleDayContinueAfterNoEventsFound(true);
            if (page > 0L || pagesize > 0L) {
                log.setPagination((int)page, (int)pagesize);
            }
            if (date != null && !"today".equals(date)) {
                log.setDate(date);
            }
            XMLWriter xml = res.getXMLWriter();
            log.toXML(xml);
            xml.flush();
        }
        catch (ParseException ex) {
            req.getLogger((Object)this).error("Could not parse date", (Throwable)ex);
            res.setError(GeneratorStatus.BAD_REQUEST, "Unparseable date '" + date + "'");
        }
        catch (IOException ex) {
            req.getLogger((Object)this).error("Unable to load log file", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, ex.getMessage());
        }
    }
}

