/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.util.WrappingReader;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.io.CharsetDetector;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentTranslator;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XMLTranslator
implements ContentTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLTranslator.class);
    private static final int BUF_SIZE = 2048;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Reader translate(Content content) throws IndexException {
        if (content.isDeleted()) {
            return null;
        }
        File f = content.getFile();
        try {
            InputStream stream;
            if (f != null) {
                int maxSize = GlobalSettings.getInt((String)"maxIndexingSize", (int)30000000);
                if (f.length() > (long)maxSize) return new StringReader("<content source=\"file\" />");
                stream = new FileInputStream(f);
                return this.validate(this.translate(stream), content.getContentID(), f == null ? null : f.getName());
            } else {
                stream = content.getSource();
            }
            return this.validate(this.translate(stream), content.getContentID(), f == null ? null : f.getName());
        }
        catch (Throwable te) {
            LOGGER.warn("Could not index the metadata in URI '{}'" + (String)(f != null ? " (" + f.getName() + ")" : ""), (Object)content.getContentID(), (Object)te);
            return new StringReader("<error>" + (te.getMessage() == null ? "Unknown error while reading XML content" : XMLUtils.escapeText((String)te.getMessage())) + "</error>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader translate(InputStream stream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
        try {
            int r;
            byte[] tmp = new byte[2048];
            while ((r = stream.read(tmp)) != -1) {
                out.write(tmp, 0, r);
            }
        }
        finally {
            stream.close();
        }
        ByteBuffer bbuf = ByteBuffer.wrap(out.toByteArray());
        CharBuffer cbuf = CharsetDetector.decodeXML((ByteBuffer)bbuf);
        return new WrappingReader((Reader)new CharBufferBackedReader(cbuf), "<content source=\"file\">", "</content>", true);
    }

    public Reader validate(Reader reader, String contentid, String filename) {
        try {
            String content = IOUtils.toString((Reader)reader);
            List errors = XMLHelpers.validateWellFormednessReturnErrors((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
            if (errors != null && !errors.isEmpty()) {
                LOGGER.warn("Invalid XML content for URI '{}' ({})", (Object)contentid, (Object)filename);
                XMLStringWriter errorsXML = new XMLStringWriter(XML.NamespaceAware.No);
                errorsXML.openElement("errors");
                errorsXML.attribute("reason", "Invalid content XML");
                for (String err : errors) {
                    errorsXML.element("error", err);
                }
                errorsXML.closeElement();
                return new StringReader(errorsXML.toString());
            }
            return new StringReader(content);
        }
        catch (Throwable ex) {
            LOGGER.warn("Invalid XML content for URI '{}' ({})", new Object[]{contentid, filename, ex});
            return new StringReader("<error>Invalid XML content: " + XMLUtils.escapeText((String)ex.getMessage()) + "</error>");
        }
    }

    static class CharBufferBackedReader
    extends Reader {
        private CharBuffer buf;

        CharBufferBackedReader(CharBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.buf == null) {
                throw new IOException("The stream has been closed.");
            }
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(cbuf, off, len);
            return len;
        }

        @Override
        public void close() {
            this.buf = null;
        }
    }
}

