/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.search.flint.DeleteRules;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSContentType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.content.DeleteRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XLinkContent
implements Content {
    private static final Logger LOGGER = LoggerFactory.getLogger(XLinkContent.class);
    private final Long _id;
    private final boolean _asTask;
    private Long deleteID = null;
    private boolean resolved = false;
    private boolean deleted = false;
    private String _mediatype = null;
    private Long _groupID = null;
    private byte[] content = null;
    private String publicationsAsXML = null;

    public XLinkContent(Long id, Long groupID, boolean asTask) {
        this._id = id;
        this._asTask = asTask;
        this._groupID = groupID;
    }

    public static XLinkContent deleteXLinkContent(Long id, boolean asTask) {
        return new XLinkContent(id, asTask);
    }

    private XLinkContent(Long id, boolean asTask) {
        this._id = id;
        this._asTask = asTask;
        this.deleted = true;
        this._groupID = null;
    }

    public ContentType getContentType() {
        return PSContentType.COMMENT;
    }

    public String getPublicationsXML() {
        if (!this.resolved) {
            this.resolve();
        }
        return this.publicationsAsXML;
    }

    public String getContentID() {
        return this._id.toString();
    }

    public InputStream getSource() {
        if (!this.resolved) {
            this.resolve();
        }
        if (this.isDeleted()) {
            return null;
        }
        return new ByteArrayInputStream(this.content);
    }

    public File getFile() {
        return null;
    }

    public String getMediaType() {
        if (!this.resolved) {
            this.resolve();
        }
        return this._mediatype;
    }

    public boolean isDeleted() {
        if (!this.resolved) {
            this.resolve();
        }
        return this.deleted;
    }

    public DeleteRule getDeleteRule() {
        return this._asTask ? DeleteRules.newTaskDeleteRule(this.deleteID) : DeleteRules.newCommentDeleteRule(this.deleteID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.resolved) {
            return;
        }
        try {
            Database db = Database.open();
            Transaction tr = null;
            try {
                Locator loc;
                tr = new Transaction(db);
                tr.begin();
                XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)this._id);
                XLink taskRoot = xl != null && this._asTask ? XLinks.getThreadRoot((XLink)xl) : null;
                Group group = DatabaseQuery.getGroupById((Database)db, (Long)this._groupID);
                boolean deleteRequested = this.deleted;
                if (!this.deleted) {
                    boolean bl = this.deleted = xl == null;
                }
                if (!this.deleted) {
                    this.deleted = !XLinkRule.belongsToGroup((XLink)(taskRoot != null ? taskRoot : xl), (Group)group);
                }
                try (UniversalPrinter xml = UniversalPrinter.newWriter((OutputType)OutputType.XML);){
                    if (this._asTask) {
                        this._mediatype = "application/vnd.pageseeder.task+xml";
                        if (!this.deleted && !XLinkRule.isTask((XLink)xl)) {
                            this.deleted = true;
                        }
                        Long l = this.deleteID = taskRoot == null || deleteRequested ? this._id : taskRoot.getId();
                        if (!this.deleted) {
                            Discussion task = new Discussion(taskRoot, Collections.singleton(group.getName()));
                            task.loadAllComments(db, 1000);
                            if (task.getReplyCount() == -1) {
                                this.deleted = true;
                            } else {
                                task.loadUri(db, group);
                                xml.writeDiscussion(task, "task", db, null, true, true, true, null);
                            }
                        }
                    } else {
                        this._mediatype = "application/vnd.pageseeder.comment+xml";
                        if (!this.deleted) {
                            this.deleted = XLinks.isArchived((XLink)xl);
                        }
                        if (!this.deleted && xl.getContentRole().equals("Workflow")) {
                            this.deleted = true;
                        }
                        Long l = this.deleteID = xl == null ? this._id : xl.getId();
                        if (!this.deleted) {
                            xml.writeComment(xl, db, null, null, true, true, true, true, null);
                        }
                    }
                    this.content = xml.toString().getBytes(StandardCharsets.UTF_8);
                }
                if (xl != null && (loc = LocatorRule.getLocatorByXLink((XLink)xl)) != null) {
                    this.publicationsAsXML = IndexUtils.getPublicationsXML(db, loc);
                }
                tr.commit();
            }
            catch (Exception ex) {
                if (tr != null) {
                    tr.abort();
                }
                throw ex;
            }
            finally {
                db.close();
                db = null;
            }
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to resolve content", ex);
        }
        finally {
            this.resolved = true;
        }
    }
}

