/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.util.WrappingReader;
import com.pageseeder.search.flint.DocumentContent;
import com.pageseeder.search.flint.URLContent;
import com.pageseeder.search.flint.XLinkContent;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentTranslator;

public final class PSTranslatorWrapper
implements ContentTranslator {
    private final String mediatype;
    private final ContentTranslator translator;

    public PSTranslatorWrapper(String mediatype) {
        this(mediatype, null);
    }

    public PSTranslatorWrapper(String mediatype, ContentTranslator translator) {
        this.mediatype = mediatype;
        this.translator = translator;
    }

    public Reader translate(Content content) throws IndexException {
        XLinkContent xlinkContent;
        String publications;
        String before = "<index-data mediatype=\"" + this.mediatype + "\">";
        Object after = "</index-data>";
        if (content.isDeleted()) {
            return new StringReader(before + "<deleted/>" + (String)after);
        }
        boolean loadContent = true;
        if (content instanceof DocumentContent) {
            String publications2;
            DocumentContent docContent = (DocumentContent)content;
            String uri = docContent.getURIAsPSML();
            if (uri != null) {
                before = before + uri;
                loadContent = false;
            }
            Object extras = "";
            String workflow = docContent.getWorkflowXML();
            if (workflow != null) {
                extras = workflow;
            }
            if ((publications2 = docContent.getPublicationsXML()) != null) {
                extras = (String)extras + publications2;
            }
            after = (String)extras + (String)after;
        } else if (content instanceof URLContent) {
            URLContent urlContent = (URLContent)content;
            String extra = urlContent.getExtraXML();
            if (extra != null) {
                after = extra + (String)after;
            }
        } else if (content instanceof XLinkContent && (publications = (xlinkContent = (XLinkContent)content).getPublicationsXML()) != null) {
            after = publications + (String)after;
        }
        try {
            Reader reader = PSTranslatorWrapper.getReader(content, this.translator, loadContent);
            return new WrappingReader(reader, before, (String)after);
        }
        catch (IOException ex) {
            throw new IndexException("Failed to read content", (Exception)ex);
        }
    }

    private static Reader getReader(Content content, ContentTranslator translator, boolean loadContent) throws IndexException {
        if (translator != null) {
            return translator.translate(content);
        }
        if (loadContent) {
            InputStream in = content.getSource();
            if (in != null) {
                return new InputStreamReader(in, StandardCharsets.UTF_8);
            }
            try {
                return new FileReader(content.getFile());
            }
            catch (FileNotFoundException ex) {
                throw new IndexException("File no longer available", (Exception)ex);
            }
        }
        return null;
    }
}

