/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.common.properties.Settings;
import com.pageseeder.search.flint.PSContentType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.content.DeleteRule;
import org.pageseeder.flint.lucene.LuceneDeleteRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PSHelpContent
implements Content {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSHelpContent.class);
    public static final File CONTENT_ROOT = new File(Settings.getContextPath(), "weborganic/help");
    private final String _id;
    private boolean resolved = false;
    private InputStream contentStream = null;
    private File contentFile = null;

    public PSHelpContent(String id) {
        this._id = id;
    }

    public String getContentID() {
        return this._id;
    }

    public ContentType getContentType() {
        return PSContentType.DOCUMENT;
    }

    public String getMediaType() {
        return "application/vnd.pageseeder.psml+xml";
    }

    public File getFile() throws IndexException {
        if (!this.resolved) {
            this.resolve();
        }
        return this.contentFile;
    }

    public InputStream getSource() throws IndexException {
        if (!this.resolved) {
            this.resolve();
        }
        return this.contentStream;
    }

    public boolean isDeleted() {
        return false;
    }

    public DeleteRule getDeleteRule() {
        return new LuceneDeleteRule("psid", this._id);
    }

    public String toString() {
        return this._id;
    }

    private void resolve() throws IndexException {
        if (this.resolved) {
            return;
        }
        try {
            this.contentFile = new File(CONTENT_ROOT, this._id);
            this.contentStream = new FileInputStream(this.contentFile);
        }
        catch (FileNotFoundException ex) {
            throw new IndexException("Failed to resolve help content from invalid file: " + this._id, (Exception)ex);
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to resolve content", ex);
        }
        finally {
            this.resolved = true;
        }
    }
}

