/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.search.flint.DocumentContent;
import com.pageseeder.search.flint.FolderContent;
import com.pageseeder.search.flint.PSContentType;
import com.pageseeder.search.flint.URLContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.content.Content;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexUtils.class);

    private IndexUtils() {
    }

    public static String buildURIContentID(Long uriid, boolean delete) {
        return IndexUtils.buildURIContentID(uriid, null, delete);
    }

    public static String buildCommentContentID(Long xlinkId, boolean delete) {
        return delete + "-" + xlinkId;
    }

    public static String buildURIContentID(Long uriid, Long releaseID, boolean delete) {
        ArrayList<String> parts = new ArrayList<String>(3);
        parts.add(Boolean.toString(delete));
        parts.add(uriid.toString());
        if (releaseID != null) {
            parts.add(releaseID.toString());
        }
        return String.join((CharSequence)"-", parts);
    }

    public static boolean isContentDeleted(String id) {
        return id != null && id.startsWith("true-");
    }

    public static boolean shouldIgnoreURI(URI uri, Database db) throws QueryFailedException, IOException {
        if (uri == null) {
            return true;
        }
        Group defaultGroup = URIRule.getDefaultGroupForURI((URI)uri);
        if (defaultGroup == null) {
            LOGGER.error("Unable to index as no default group for URI ID: {} Path: {}", (Object)uri.getId(), (Object)uri.getPath());
            return true;
        }
        Properties props = GroupProperties.get((Database)db, (Group)defaultGroup);
        String ignoreFolders = (String)props.get("indexIgnoreFolders");
        ArrayList<Object> indexIgnoreFolders = null;
        indexIgnoreFolders = ignoreFolders != null ? new ArrayList<String>(Arrays.asList(ignoreFolders.split(", ?"))) : new ArrayList<String>();
        indexIgnoreFolders.add("archive");
        String ps = GlobalSettings.getSitePrefix();
        for (String string : indexIgnoreFolders) {
            String ignorePath = ps + "/" + defaultGroup.getName().replace('-', '/') + "/" + string;
            if (!uri.getPath().equals(ignorePath) && !uri.getPath().startsWith(ignorePath + "/")) continue;
            return true;
        }
        return false;
    }

    public static Long[] getURIContentIDs(String id) {
        String[] parts = id.split("-");
        return new Long[]{Long.parseLong(parts[1]), parts.length > 2 ? Long.valueOf(Long.parseLong(parts[2])) : null};
    }

    public static Long getCommentContentID(String id) {
        String[] parts = id.split("-");
        return parts.length > 1 ? Long.valueOf(Long.parseLong(parts[1])) : null;
    }

    public static Content toContent(URI uri, Long groupId, Long releaseID, boolean withGroups) {
        if (URIs.isExternal((URI)uri)) {
            return new URLContent(uri.getId(), groupId, releaseID, withGroups);
        }
        if ("folder".equals(uri.getType())) {
            return new FolderContent(uri.getId(), groupId);
        }
        return new DocumentContent(uri.getId(), groupId, releaseID, null);
    }

    public static PSContentType toContentType(URI uri) {
        if (URIs.isExternal((URI)uri)) {
            return PSContentType.URL;
        }
        if ("folder".equals(uri.getType())) {
            return PSContentType.FOLDER;
        }
        return PSContentType.DOCUMENT;
    }

    public static Map<String, String> buildParameters(URI uri, Group group, Long releaseID) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("psid-field-value", uri.getId().toString() + (releaseID != null ? "#version" : ""));
        if (group != null) {
            params.put("groupname", group.getName());
        }
        return params;
    }

    public static String getWorkflowXML(Database db, URI uri, Long releaseid) throws QueryFailedException {
        List workflows = URIRule.getWorkflowsForURI((Database)db, (URI)uri, null);
        if (workflows.isEmpty()) {
            return null;
        }
        try (UniversalPrinter xml = UniversalPrinter.newWriter((OutputType)OutputType.XML);){
            xml.writeWorkflow(workflows, false, true, null, releaseid);
            String string = xml.toString();
            return string;
        }
    }

    public static String getPublicationsXML(Database db, URI uri, @Nullable Long releaseID) throws QueryFailedException {
        HashSet<Publication> pubs;
        if (releaseID != null) {
            pubs = new HashSet<Publication>();
            Publication pub = DatabaseQuery.getPublicationByVersion((Database)db, (Long)releaseID);
            if (pub != null) {
                pubs.add(pub);
            }
        } else {
            pubs = new HashSet(DatabaseQuery.getPublicationsByURIEmbeded((Database)db, (Long)uri.getId()));
            Publication root = DatabaseQuery.getPublicationByRootURI((Database)db, (URI)uri, (boolean)false);
            if (root != null) {
                pubs.add(root);
            }
        }
        return IndexUtils.toPublicationXML(pubs);
    }

    public static String getPublicationsXML(Database db, Locator loc) throws QueryFailedException {
        List pubs = DatabaseQuery.getPublicationsByLocator((Database)db, (Locator)loc);
        return IndexUtils.toPublicationXML(pubs);
    }

    private static String toPublicationXML(Collection<Publication> publications) {
        if (publications.isEmpty()) {
            return null;
        }
        try (UniversalPrinter xml = UniversalPrinter.newWriter((OutputType)OutputType.XML);){
            xml.startCollection("publications");
            for (Publication pub : publications) {
                Publications.print((Publication)pub, (UniversalPrinter)xml);
            }
            xml.endCollection();
            String string = xml.toString();
            return string;
        }
    }
}

