/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.xml.XMLUtils;
import com.pageseeder.search.flint.XMLTranslator;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocXTranslator
implements ContentTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocXTranslator.class);
    private static final String DOCUMENT_PATH = "word/document.xml";
    private static final String DOCUMENT_PATH2 = "document.xml";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reader translate(Content content) throws IndexException {
        if (content.isDeleted()) {
            return null;
        }
        File f = content.getFile();
        try {
            XMLTranslator xmlTranslator = new XMLTranslator();
            if (f == null) {
                InputStream stream = content.getSource();
                return xmlTranslator.translate(stream);
            }
            try (ZipFile zip = new ZipFile(f);){
                ZipEntry doc = zip.getEntry(DOCUMENT_PATH);
                if (doc == null) {
                    doc = zip.getEntry(DOCUMENT_PATH2);
                }
                if (doc == null) {
                    throw new IndexException("Failed to index DocX document as word/document.xml or document.xml cannot be found.", (Exception)new IllegalArgumentException());
                }
                int maxSize = GlobalSettings.getInt((String)"maxIndexingSize", (int)30000000);
                if (doc.getSize() <= (long)maxSize) {
                    InputStream stream = zip.getInputStream(doc);
                    Reader reader = xmlTranslator.translate(stream);
                    return reader;
                }
                StringReader stringReader = new StringReader("<content source=\"file\" />");
                return stringReader;
            }
        }
        catch (Throwable te) {
            String string;
            LOGGER.warn("Could not index the metadata in URI '{}'" + (String)(f != null ? " (" + f.getName() + ")" : ""), (Object)content.getContentID(), (Object)te);
            if (te.getMessage() == null) {
                string = "Unknown error while reading DocX content";
                return new StringReader("<error>" + string + "</error>");
            }
            string = XMLUtils.escapeText((String)te.getMessage());
            return new StringReader("<error>" + string + "</error>");
        }
    }
}

