/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.db.Database;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSContentType;
import com.pageseeder.search.flint.PSRequester;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.pageseeder.flint.indexing.IndexBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchIndexJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchIndexJob.class);
    private final PSRequester _requester;
    private final Map<Group, GroupBatch> _batches = new HashMap<Group, GroupBatch>();
    private final GroupBatch _urlBatch;

    public BatchIndexJob(String name) {
        this._requester = new PSRequester(name);
        this._urlBatch = new GroupBatch(this._requester);
    }

    public void index(Database db, URI uri, Iterator<Group> grps) {
        this.index(db, uri, null, grps);
    }

    public void index(Database db, URI uri, Long version, Iterator<Group> grps) {
        if (version != null && URIRule.isFolder((URI)uri)) {
            return;
        }
        if (URIs.isExternal((URI)uri)) {
            if (URIs.canBeIndexedAsURL((URI)uri)) {
                this._urlBatch.indexLastOne(db, null, false);
                this._urlBatch.setLastContent(uri, version, null, uri.isArchived());
            }
        } else {
            IndexMaster master = IndexMaster.getInstance();
            while (grps.hasNext()) {
                GroupBatch batch;
                Group group;
                block10: {
                    group = grps.next();
                    if (!master.isIndexable(db, group)) continue;
                    if (version != null) {
                        try {
                            if ("false".equals(GroupProperties.get((Database)db, (Group)group).getProperty("indexVersions", "false"))) {
                            }
                            break block10;
                        }
                        catch (QueryFailedException | IOException ex) {
                            LOGGER.error("Failed to load group properties for {}, versions will not be indexed", (Object)group.getName(), (Object)ex);
                        }
                        continue;
                    }
                }
                if ((batch = this._batches.get(group)) == null) {
                    batch = new GroupBatch(group, this._requester);
                    this._batches.put(group, batch);
                }
                batch.indexLastOne(db, group, false);
                if (IndexMaster.shouldIgnoreURI(uri.getPath())) continue;
                batch.setLastContent(uri, version, group, false);
            }
        }
    }

    public void index(Database db, XLink xl, Iterator<Group> grps) {
        IndexMaster master = IndexMaster.getInstance();
        while (grps.hasNext()) {
            Group group = grps.next();
            if (!master.isIndexable(db, group)) continue;
            GroupBatch batch = this._batches.get(group);
            if (batch == null) {
                batch = new GroupBatch(group, this._requester);
                this._batches.put(group, batch);
            }
            batch.indexLastOne(db, group, false);
            batch.setLastContent(xl, false);
        }
    }

    public void delete(Database db, URI uri, Iterator<Group> grps) {
        if (URIs.isExternal((URI)uri)) {
            if (URIs.canBeIndexedAsURL((URI)uri)) {
                this._urlBatch.indexLastOne(db, null, false);
                this._urlBatch.setLastContent(uri, null, null, true);
            }
        } else {
            IndexMaster master = IndexMaster.getInstance();
            while (grps.hasNext()) {
                Group group = grps.next();
                if (!master.isIndexable(db, group)) continue;
                GroupBatch batch = this._batches.get(group);
                if (batch == null) {
                    batch = new GroupBatch(group, this._requester);
                    this._batches.put(group, batch);
                }
                batch.indexLastOne(db, group, false);
                batch.setLastContent(uri, null, group, true);
            }
        }
    }

    public void delete(Database db, String contentID, PSContentType type, Iterator<Group> grps) {
        if (type == PSContentType.URL) {
            this._urlBatch.indexLastOne(db, null, false);
            this._urlBatch.setLastContent(contentID, type);
        } else {
            IndexMaster master = IndexMaster.getInstance();
            while (grps.hasNext()) {
                Group group = grps.next();
                if (!master.isIndexable(db, group)) continue;
                GroupBatch batch = this._batches.get(group);
                if (batch == null) {
                    batch = new GroupBatch(group, this._requester);
                    this._batches.put(group, batch);
                }
                batch.indexLastOne(db, group, false);
                batch.setLastContent(contentID, type);
            }
        }
    }

    public void complete(Database db) {
        for (Group group : this._batches.keySet()) {
            this._batches.get(group).indexLastOne(db, group, true);
        }
        this._urlBatch.indexLastOne(db, null, true);
    }

    private static class GroupBatch {
        private final PSRequester _requester;
        private final IndexBatch _batch;
        private String lastContentID = null;
        private PSContentType lastContentType = null;
        private Map<String, String> lastParameters = null;
        private boolean lastSlowLane = false;
        private boolean lastIsComment = false;

        public GroupBatch(Group group, PSRequester req) {
            this._batch = new IndexBatch(String.valueOf(group.getId()) + "/" + group.getName() + "/" + req.process());
            this._requester = req;
        }

        public GroupBatch(PSRequester req) {
            this._batch = new IndexBatch("urls/urls/" + req.process());
            this._requester = req;
        }

        public void indexLastOne(Database db, Group group, boolean last) {
            if (this.lastContentID == null) {
                return;
            }
            if (this.lastIsComment) {
                this._batch.increaseTotal();
            }
            this._batch.increaseTotal();
            if (last) {
                this._batch.setComputed();
            }
            IndexMaster master = IndexMaster.getInstance();
            if (this.lastIsComment) {
                master.launchIndexJob(this.lastContentID, PSContentType.COMMENT, this._batch, group, db, null, this._requester, false, false);
                master.launchIndexJob(this.lastContentID, PSContentType.TASK, this._batch, group, db, null, this._requester, false, false);
            } else if (this.lastContentType == PSContentType.URL) {
                master.indexURL(IndexUtils.getURIContentIDs(this.lastContentID)[0], IndexUtils.isContentDeleted(this.lastContentID), this._batch, this._requester);
            } else {
                master.launchIndexJob(this.lastContentID, this.lastContentType, this._batch, group, db, this.lastParameters, this._requester, false, this.lastSlowLane);
            }
            this.lastContentID = null;
            this.lastContentType = null;
            this.lastParameters = null;
            this.lastSlowLane = false;
            this.lastIsComment = false;
        }

        protected void setLastContent(String cid, PSContentType type) {
            this.lastContentID = cid;
            this.lastContentType = type;
            this.lastParameters = null;
            this.lastSlowLane = false;
            this.lastIsComment = PSContentType.COMMENT.equals((Object)type) || PSContentType.TASK.equals((Object)type);
        }

        protected void setLastContent(URI uri, Long version, Group group, boolean delete) {
            this.lastContentID = IndexUtils.buildURIContentID(uri.getId(), version, delete);
            this.lastContentType = IndexUtils.toContentType(uri);
            this.lastParameters = group == null ? null : IndexUtils.buildParameters(uri, group, version);
            this.lastSlowLane = IndexMaster.getInstance().isSlowLane(uri);
            this.lastIsComment = false;
        }

        protected void setLastContent(XLink xl, boolean delete) {
            this.lastContentID = IndexUtils.buildCommentContentID(xl.getId(), delete);
            this.lastContentType = null;
            this.lastParameters = null;
            this.lastSlowLane = false;
            this.lastIsComment = true;
        }
    }
}

