/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.search.URILookupQuery;
import com.pageseeder.search.flint.IndexMaster;
import java.io.IOException;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true, uri=true)
@PublicAPI
public final class GetIndexedDocument
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        return new ViewGroupCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        Database db = req.getDatabase();
        URI uri = req.getURI();
        String id = uri.getId().toString();
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("indexed-document");
        xml.attribute("for", id);
        IndexMaster master = IndexMaster.getInstance();
        if (master.isIndexable(db, group)) {
            try {
                SearchResults results = master.search(db, group, (SearchQuery)new URILookupQuery(id), 1, 1);
                results.toXML(xml);
            }
            catch (IndexException ex) {
                throw new IOException(ex);
            }
        }
        xml.closeElement();
    }
}

