/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.Strings;
import com.pageseeder.search.GroupIndexingThread;
import com.pageseeder.search.utils.IndexingThreadBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

@Requires(group=true, member=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class FolderIndexing
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (!"folder".equals(req.getURI().getType())) {
            return new ForbiddenCheck();
        }
        return new EditGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        List<String> types = Arrays.asList(Strings.split((String)req.getParameter((Parameter)StandardParameters.types, ""), (char)','));
        GroupIndexingThread thread = GroupIndexingThread.newInstance(req.getMember().getUsername(), "Indexing folder " + req.getURI().getDecodedPath() + " in group " + req.getGroup().getName(), req.getGroup());
        thread.setFolderID(req.getURI().getId());
        if (types.contains("document")) {
            thread.addTypeToindex(IndexingThreadBase.INDEXTYPE.DOCUMENT);
        }
        if (types.contains("comment")) {
            thread.addTypeToindex(IndexingThreadBase.INDEXTYPE.COMMENT);
        }
        if (types.contains("version")) {
            thread.addTypeToindex(IndexingThreadBase.INDEXTYPE.VERSION);
        }
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("folder-indexing");
        thread.print((OutputPrinter)out);
        out.endObject();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }
}

