/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.toc;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.PublicationNumbering;

public final class NumberingGenerator {
    private PublicationNumbering numberConfig;
    private Map<String, ArrayDeque<Integer>> numberingLevels = new HashMap<String, ArrayDeque<Integer>>();

    public NumberingGenerator(PublicationNumbering cfg) {
        this.numberConfig = cfg;
        this.numberingLevels.put("", new ArrayDeque(9));
    }

    public PublicationNumbering getPublicationNumbering() {
        return this.numberConfig;
    }

    public FragmentNumbering.Prefix generateNumbering(int level, String element, String blocklabel) {
        if (this.numberConfig != null && this.numberConfig.hasScheme(level, blocklabel, element)) {
            String label = this.numberConfig.getNumberFormat(level, blocklabel) == null ? "" : blocklabel;
            this.addNewLevel(level, label);
            String canonical = this.canonicalLabel(label);
            return this.numberConfig.getPrefix(canonical, label);
        }
        return null;
    }

    public void restartNumbering(int level) {
        if (!this.numberConfig.hasRestarts()) {
            return;
        }
        Set<String> labels = this.numberingLevels.keySet();
        for (String label : labels) {
            if (!this.numberConfig.hasRestart(level, "") && ("".equals(label) || !this.numberConfig.hasRestart(level, label))) continue;
            Deque levels = this.numberingLevels.get(label);
            while (levels.size() > level) {
                levels.pop();
            }
        }
    }

    private void addNewLevel(int level, String blocklabel) {
        if (this.numberConfig.getNumberFormat(level, blocklabel) != null && !this.numberingLevels.containsKey(blocklabel)) {
            Object blocklevels = this.numberingLevels.get("").clone();
            while (((ArrayDeque)blocklevels).size() >= level) {
                ((ArrayDeque)blocklevels).pop();
            }
            this.numberingLevels.put(blocklabel, (ArrayDeque<Integer>)blocklevels);
        }
        Set<String> labels = this.numberingLevels.keySet();
        for (String label : labels) {
            boolean blockdefined;
            boolean bl = blockdefined = this.numberConfig.getNumberFormat(level, label) != null;
            if ((!blockdefined || !label.equals(blocklabel)) && (blockdefined || !"".equals(blocklabel))) continue;
            Deque levels = this.numberingLevels.get(label);
            if (levels.size() == level) {
                levels.push((Integer)levels.pop() + 1);
                continue;
            }
            if (levels.size() + 1 == level) {
                levels.push(1);
                continue;
            }
            while (levels.size() > level) {
                if (label.isEmpty()) {
                    levels.pop();
                    continue;
                }
                String format = this.numberConfig.getNumberFormat(levels.size(), label);
                if (format != null && !format.matches("\\[(.*?)" + level + "(.*?)\\]")) break;
                levels.pop();
            }
            while (levels.size() < level) {
                levels.push(this.numberConfig.getSkippedLevels() == PublicationNumbering.SkippedLevels.ONE && levels.size() < level - 1 && "".equals(label) ? 1 : 0);
            }
            if (levels.size() != level) continue;
            levels.push((Integer)levels.pop() + 1);
        }
    }

    private String canonicalLabel(String blocklabel) {
        Deque levels = this.numberingLevels.get(blocklabel);
        if (levels == null) {
            levels = this.numberingLevels.get("");
        }
        StringBuilder label = new StringBuilder();
        Iterator leveli = levels.descendingIterator();
        while (leveli.hasNext()) {
            label.append(leveli.next()).append('.');
        }
        return label.toString();
    }
}

