/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.toc;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public abstract class Element
implements Serializable,
XMLWritable {
    private static final long serialVersionUID = 1L;
    public static final String NO_TITLE = "";
    public static final String NO_FRAGMENT = "";
    private final int level;
    private final String title;
    private final String fragment;
    private final String originalFragment;

    public Element(int level) {
        this.level = level;
        this.title = "";
        this.fragment = "";
        this.originalFragment = "";
    }

    public Element(int level, String title, String fragment, String originalFragment) {
        if (level < 0) {
            throw new IllegalArgumentException("Level must be > 0 but was " + level);
        }
        this.level = level;
        this.title = title;
        this.fragment = fragment;
        this.originalFragment = originalFragment;
    }

    public final int level() {
        return this.level;
    }

    public final String title() {
        return this.title;
    }

    public String fragment() {
        return this.fragment;
    }

    public String originalFragment() {
        return this.originalFragment;
    }

    public final boolean hasTitle() {
        return !"".equals(this.title);
    }

    public final String toString() {
        StringBuilder out = new StringBuilder();
        this.print(out);
        return out.toString();
    }

    public abstract void print(Appendable var1);

    public abstract void toXML(XMLWriter var1, int var2, @Nullable FragmentNumbering var3, long var4, int var6) throws IOException;

    public void toXML(XMLWriter xml, int level, @Nullable FragmentNumbering number, long treeid, int count, boolean numbered, String prefix, boolean children) throws IOException {
        this.toXML(xml, level, number, treeid, count);
    }

    public void toXML(XMLWriter xml) throws IOException {
        this.toXML(xml, this.level(), null, -1L, -1);
    }
}

