/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.toc;

import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.Element;
import org.pageseeder.psml.toc.Heading;
import org.pageseeder.psml.toc.Paragraph;
import org.pageseeder.psml.toc.Part;
import org.pageseeder.psml.toc.Phantom;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.psml.toc.Reference;
import org.pageseeder.psml.toc.TitleCollapse;
import org.pageseeder.psml.toc.Tree;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class DocumentTree
implements Tree,
Serializable,
XMLWritable {
    private static final long serialVersionUID = 3L;
    public static final String NO_PREFIX = "";
    public static final String NO_BLOCK_LABEL = "";
    public static final String NO_FRAGMENT = "";
    private final long _id;
    private final transient int _level;
    private final String _title;
    private final String _labels;
    private final List<Long> _reverse;
    private final List<Part<?>> _parts;
    private final String _titlefragment;
    private final boolean _numbered;
    private final String _prefix;
    private final String _blocklabel;
    private final OffsetDateTime _lastedited;
    private final String _path;
    private final Map<String, String> _fragmentheadings;
    private final Boolean _xmlheadings;
    private final Map<String, Integer> _fragmentlevels;

    public DocumentTree(long id, int level, String title, String labels, List<Long> reverse, String titlefragment, boolean numbered, String prefix, String blocklabel, OffsetDateTime lastedited, String path, List<Part<?>> parts, Map<String, String> fragmentheadings, Map<String, Integer> fragmentlevels) {
        this._id = id;
        this._title = title;
        this._labels = labels;
        this._reverse = Collections.unmodifiableList(reverse);
        this._parts = Collections.unmodifiableList(parts);
        this._level = level;
        this._titlefragment = titlefragment;
        this._numbered = numbered;
        this._prefix = prefix;
        this._blocklabel = blocklabel;
        this._lastedited = lastedited;
        this._path = path;
        this._fragmentheadings = Collections.unmodifiableMap(fragmentheadings);
        this._xmlheadings = true;
        this._fragmentlevels = Collections.unmodifiableMap(fragmentlevels);
    }

    public DocumentTree(long id, String title, String labels, OffsetDateTime lastedited, String path, List<Long> reverse, List<Part<?>> parts, Map<String, String> fragmentheadings, Map<String, Integer> fragmentlevels) {
        this(id, DocumentTree.calculateLevel(parts), title, labels, reverse, "", false, "", "", lastedited, path, parts, fragmentheadings, fragmentlevels);
    }

    @Override
    public long id() {
        return this._id;
    }

    @Override
    public String title() {
        return this._title;
    }

    public String labels() {
        return this._labels;
    }

    public int level() {
        return this._level;
    }

    public String getPrefixedTitle() {
        return !"".equals(this._prefix) ? this._prefix + " " + this.title() : this.title();
    }

    public String titlefragment() {
        return this._titlefragment;
    }

    public String prefix() {
        return this._prefix;
    }

    public String blocklabel() {
        return this._blocklabel;
    }

    public @Nullable OffsetDateTime lastedited() {
        return this._lastedited;
    }

    public String path() {
        return this._path;
    }

    public boolean numbered() {
        return this._numbered;
    }

    public Map<String, String> fragmentheadings() {
        return Collections.unmodifiableMap(this._fragmentheadings);
    }

    public boolean xmlheadings() {
        return this._xmlheadings == null ? false : this._xmlheadings;
    }

    public Map<String, Integer> fragmentlevels() {
        return Collections.unmodifiableMap(this._fragmentlevels);
    }

    @Override
    public List<Long> listReverseReferences() {
        return this._reverse;
    }

    @Override
    public List<Long> listForwardReferences() {
        ArrayList<Long> uris = new ArrayList<Long>();
        for (Part<?> c : this._parts) {
            DocumentTree.collectReferencesIds(c, uris);
        }
        return uris;
    }

    public List<Reference> listReferences() {
        ArrayList<Reference> refs = new ArrayList<Reference>();
        for (Part<?> c : this._parts) {
            DocumentTree.collectReferences(c, refs);
        }
        return refs;
    }

    public boolean hasVisibleItems(@Nullable PublicationConfig config, @Nullable String fragment) {
        for (Part<?> c : this._parts) {
            if (!DocumentTree.hasVisibleItems(c, config, fragment)) continue;
            return true;
        }
        return false;
    }

    private static void collectReferencesIds(Part<?> part, List<Long> uris) {
        Reference ref;
        Object element = part.element();
        if (element instanceof Reference && !uris.contains((ref = (Reference)element).uri())) {
            uris.add(ref.uri());
        }
        for (Part<?> c : part.parts()) {
            DocumentTree.collectReferencesIds(c, uris);
        }
    }

    private static void collectReferences(Part<?> part, List<Reference> refs) {
        Object element = part.element();
        if (element instanceof Reference) {
            Reference ref = (Reference)element;
            refs.add(ref);
        }
        for (Part<?> c : part.parts()) {
            DocumentTree.collectReferences(c, refs);
        }
    }

    private static boolean hasVisibleItems(Part<?> part, @Nullable PublicationConfig config, @Nullable String fragment) {
        Object element = part.element();
        if ((element instanceof Reference && Reference.Type.EMBED.equals((Object)((Reference)element).type()) || element instanceof Heading || element instanceof Paragraph && ((Paragraph)element).isVisible(config)) && (fragment == null || fragment.equals(((Element)element).fragment()))) {
            return true;
        }
        for (Part<?> c : part.parts()) {
            if (!DocumentTree.hasVisibleItems(c, config, fragment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReferenced() {
        return !this._reverse.isEmpty();
    }

    public List<Part<?>> parts() {
        return this._parts;
    }

    public boolean isEmpty() {
        return this._parts.isEmpty();
    }

    public DocumentTree singleFragmentTree(String fragment) {
        List<Part<?>> parts = DocumentTree.removeOtherFragments(this.parts(), fragment, false);
        if (parts == null) {
            parts = new ArrayList();
        }
        DocumentTree tree = new DocumentTree(this._id, this._title, this._labels, this._lastedited, this._path, this._reverse, parts, this._fragmentheadings, this._fragmentlevels);
        return DocumentTree.removePhantomParts(tree);
    }

    public DocumentTree normalize(TitleCollapse collapse) {
        DocumentTree normalized = this;
        normalized = DocumentTree.removePhantomParts(normalized);
        normalized = DocumentTree.removeTitleHeading(normalized, collapse);
        return normalized;
    }

    public void toXML(XMLWriter xml) throws IOException {
        String reverse = this.toReverseReferencesString(",");
        xml.openElement("document-tree", this._parts.size() > 0);
        xml.attribute("id", Long.toString(this._id));
        xml.attribute("level", this._level);
        xml.attribute("title", this._title);
        if (this.numbered()) {
            xml.attribute("numbered", "true");
        }
        if (!"".equals(this.prefix())) {
            xml.attribute("prefix", this.prefix());
        }
        if (reverse.length() > 0) {
            xml.attribute("reverse-references", reverse);
        }
        for (Part<?> p : this._parts) {
            p.toXML(xml);
        }
        xml.closeElement();
    }

    public @NonNull String toString() {
        return "DocumentTree(" + this._id + "," + this._title + ")";
    }

    @Override
    public void print(Appendable out) {
        try {
            out.append(Long.toString(this._id)).append(':').append(this._title).append('\n');
            for (Part<?> p : this._parts) {
                p.print(out);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static DocumentTree removePhantomParts(DocumentTree tree) {
        DocumentTree normalized = tree;
        while (normalized.parts().size() == 1 && !normalized.parts().get(0).hasTitle()) {
            ArrayList unwrapped = new ArrayList();
            for (Part<?> p : normalized.parts().get(0).parts()) {
                unwrapped.add(p);
            }
            normalized = new DocumentTree(tree._id, DocumentTree.calculateLevel(unwrapped), tree._title, tree._labels, tree._reverse, tree._titlefragment, tree._numbered, tree._prefix, tree._blocklabel, tree._lastedited, tree._path, unwrapped, tree._fragmentheadings, tree._fragmentlevels);
        }
        return normalized;
    }

    private static int calculateLevel(List<Part<?>> parts) {
        int level = 0;
        for (Part<?> part : parts) {
            Object el = part.element();
            if (!(el instanceof Phantom) && !(el instanceof Heading)) continue;
            return ((Element)el).level();
        }
        return level;
    }

    public static DocumentTree removeTitleHeading(DocumentTree tree, TitleCollapse collapse) {
        List<Part<?>> parts = tree.parts();
        if (parts.isEmpty()) {
            return tree;
        }
        Part<?> firstPart = parts.get(0);
        if (!(firstPart.element() instanceof Heading)) {
            return tree;
        }
        Heading firstHeading = (Heading)firstPart.element();
        String headingTitle = firstHeading.title();
        String prefixedTitle = firstHeading.getPrefixedTitle();
        String documentTitle = tree._title;
        if ((headingTitle.equals(documentTitle) || prefixedTitle.equals(documentTitle) || collapse == TitleCollapse.always) && collapse != TitleCollapse.never && parts.size() == 1) {
            ArrayList children = new ArrayList();
            for (Part<?> p : firstPart.parts()) {
                children.add(p);
            }
            return new DocumentTree(tree._id, firstHeading.level() + 1, firstHeading.title(), tree._labels, tree._reverse, firstHeading.fragment(), firstHeading.numbered(), firstHeading.prefix(), firstHeading.blocklabel(), tree._lastedited, tree._path, children, tree._fragmentheadings, tree._fragmentlevels);
        }
        return tree;
    }

    public static @Nullable List<Part<?>> removeOtherFragments(List<Part<?>> parts, String fragment, boolean found) {
        ArrayList modified = new ArrayList();
        if (!parts.isEmpty()) {
            for (Part<?> part : parts) {
                List<Part<?>> branch;
                Object el = part.element();
                if (fragment.equals(((Element)el).fragment())) {
                    modified.add(new Part(el, DocumentTree.removeOtherFragments(part.parts(), fragment, true)));
                    continue;
                }
                if (found || (branch = DocumentTree.removeOtherFragments(part.parts(), fragment, false)) == null) continue;
                modified.add(new Part<Phantom>(new Phantom(((Element)el).level(), ((Element)el).fragment(), ((Element)el).originalFragment()), branch));
            }
        }
        return modified.isEmpty() && !found ? null : modified;
    }

    public static class Builder {
        private long id = -1L;
        private String title = "[untitled]";
        private String labels = "";
        private @Nullable OffsetDateTime lastedited = null;
        private String path = "";
        private final List<Part<?>> parts = new ArrayList();
        private final List<Long> reverse = new ArrayList<Long>();
        private final Map<String, String> fragmentheadings = new HashMap<String, String>();
        private final Map<String, Integer> fragmentlevels = new HashMap<String, Integer>();

        public Builder() {
        }

        public Builder(long id) {
            if (id < 0L) {
                throw new IllegalArgumentException("URI ID must be positive");
            }
            this.id = id;
        }

        public Builder(long id, String title) {
            this(id);
            this.title(title);
        }

        public long id() {
            return this.id;
        }

        public Builder id(long id) {
            if (id < 0L) {
                throw new IllegalArgumentException("URI ID must be positive");
            }
            this.id = id;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder labels(String labels) {
            this.labels = labels;
            return this;
        }

        public Builder lastedited(OffsetDateTime lastedited) {
            this.lastedited = lastedited;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder parts(List<Part<?>> parts) {
            this.parts.addAll(parts);
            return this;
        }

        public Builder part(Part<?> part) {
            this.parts.add(part);
            return this;
        }

        public Builder addReverseReference(Long ref) {
            this.reverse.add(ref);
            return this;
        }

        public Builder addReverseReferenceIfNew(Long ref) {
            if (!this.reverse.contains(ref)) {
                this.reverse.add(ref);
            }
            return this;
        }

        public Builder putFragmentHeading(String fragment, String heading) {
            this.fragmentheadings.put(fragment, heading);
            return this;
        }

        public Builder putFragmentLevel(String fragment, int level) {
            this.fragmentlevels.put(fragment, level);
            return this;
        }

        public DocumentTree build() {
            if (this.id < 0L) {
                throw new IllegalStateException("URI ID must be set");
            }
            ArrayList parts = new ArrayList(this.parts);
            ArrayList<Long> reverse = new ArrayList<Long>(this.reverse);
            HashMap<String, String> fragmentheadings = new HashMap<String, String>(this.fragmentheadings);
            HashMap<String, Integer> fragmentlevels = new HashMap<String, Integer>(this.fragmentlevels);
            return new DocumentTree(this.id, this.title, this.labels, this.lastedited, this.path, reverse, parts, fragmentheadings, fragmentlevels);
        }
    }
}

