/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public final class IncludesExcludesMatcher {
    private final List<String> excludePatterns = new ArrayList<String>();
    private final List<String> includePatterns = new ArrayList<String>();

    public void addIncludePatterns(@Nullable List<String> patterns) {
        if (patterns == null) {
            return;
        }
        for (String inc : patterns) {
            if (inc.length() <= 0) continue;
            this.includePatterns.add(IncludesExcludesMatcher.createRegex(inc));
        }
    }

    public void addIncludePatterns(@Nullable String[] patterns) {
        if (patterns == null) {
            return;
        }
        for (String inc : patterns) {
            if (inc.length() <= 0) continue;
            this.includePatterns.add(IncludesExcludesMatcher.createRegex(inc));
        }
    }

    public void addIncludePattern(@Nullable String pattern) {
        if (pattern == null) {
            return;
        }
        this.includePatterns.add(IncludesExcludesMatcher.createRegex(pattern));
    }

    public void addExcludePatterns(@Nullable List<String> patterns) {
        if (patterns == null) {
            return;
        }
        for (String exc : patterns) {
            if (exc.length() <= 0) continue;
            this.excludePatterns.add(IncludesExcludesMatcher.createRegex(exc));
        }
    }

    public void addExcludePatterns(@Nullable String[] patterns) {
        if (patterns == null) {
            return;
        }
        for (String exc : patterns) {
            if (exc.length() <= 0) continue;
            this.excludePatterns.add(IncludesExcludesMatcher.createRegex(exc));
        }
    }

    public void addExcludePattern(@Nullable String pattern) {
        if (pattern == null) {
            return;
        }
        this.excludePatterns.add(IncludesExcludesMatcher.createRegex(pattern));
    }

    public boolean isExcluded(@Nullable String path) {
        if (path != null) {
            for (String exc : this.excludePatterns) {
                if (!path.matches(exc)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isIncluded(@Nullable String path) {
        if (!this.includePatterns.isEmpty()) {
            if (path == null) {
                return false;
            }
            for (String inc : this.includePatterns) {
                if (!path.matches(inc)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean matches(String path) {
        return this.isIncluded(path) && !this.isExcluded(path);
    }

    public boolean hasPatterns() {
        return !this.includePatterns.isEmpty() || !this.excludePatterns.isEmpty();
    }

    private static String createRegex(String pattern) {
        return "^" + pattern.replaceAll("[\\.\\(\\)\\[\\]\\^\\$\\+]", "\\\\$0").replaceAll("\\*\\*", "[psdoublestar]").replaceAll("\\*", "([^/]*?)").replaceAll("\\[psdoublestar\\]", "(.*?)") + "$";
    }
}

