/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process.math;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.util.WrappingReader;
import org.pageseeder.psml.util.PSCache;

public final class TexConverter {
    private static final String JS_SCRIPT = "/org/pageseeder/psml/process/math/katex.0.16.9.min.js";
    private static @Nullable Invocable script = null;
    private static final Map<String, String> cache = Collections.synchronizedMap(new PSCache(200));

    private TexConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convert(@Nullable String input) {
        if (input == null || input.trim().isEmpty()) {
            return "";
        }
        String result = cache.get(input = input.trim());
        if (result == null) {
            try {
                Class<TexConverter> clazz = TexConverter.class;
                synchronized (TexConverter.class) {
                    result = TexConverter.script().invokeFunction("parse", input).toString();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    result = TexConverter.extractMathML(result);
                    cache.put(input, result);
                }
            }
            catch (IOException | NoSuchMethodException | ScriptException ex) {
                throw new IllegalArgumentException("Failed to run KaTex to MathML JS script: " + ex.getMessage());
            }
        }
        return result;
    }

    private static String extractMathML(String result) {
        int start = result.indexOf("<math");
        if (start > 0) {
            int semantics = result.indexOf("<semantics>", start);
            if (semantics > 0) {
                start = semantics + 11;
                int annotation = result.indexOf("<annotation encoding=\"application/x-tex\">");
                result = annotation > 0 ? result.substring(start, annotation) : result.substring(start, result.indexOf("</semantics>", start + 1));
                return "<math xmlns=\"http://www.w3.org/1998/Math/MathML\">" + result + "</math>";
            }
            return result.substring(start, result.indexOf("</math>", start + 1) + 7);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Invocable script() throws ScriptException, IOException {
        Class<TexConverter> clazz = TexConverter.class;
        synchronized (TexConverter.class) {
            if (script != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return script;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("rhino");
            Compilable cengine = (Compilable)((Object)engine);
            try {
                InputStream in = TexConverter.class.getResourceAsStream(JS_SCRIPT);
                if (in != null) {
                    String scriptPrefix = "Array.prototype.fill = function(arg) { for (var i = 0; i < this.length; i++) { this[i] = arg; } };";
                    String scriptSuffix = "var parse = function(str) { return katex.renderToString(str, { output: 'mathml' }); };";
                    CompiledScript cscript = cengine.compile(new WrappingReader(new InputStreamReader(in), scriptPrefix, scriptSuffix));
                    cscript.eval();
                    script = (Invocable)((Object)cscript.getEngine());
                    return script;
                }
                throw new IllegalArgumentException("Failed to load KaTex to MathML JS script");
            }
            catch (IOException | ScriptException ex) {
                System.err.println("Failed to load KaTex to MathML JS script: " + ex.getMessage());
                throw ex;
            }
        }
    }
}

