/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.md;

public final class MarkdownInputOptions {
    public static final MarkdownInputOptions DEFAULT_FRAGMENT = new MarkdownInputOptions(66, false, false);
    public static final MarkdownInputOptions DEFAULT_DOCUMENT = new MarkdownInputOptions(66, true, true);
    private final int lineBreakThreshold;
    private final boolean isDocumentMode;
    private final boolean newFragmentPerHeading;

    MarkdownInputOptions(int lineBreakThreshold, boolean isDocumentMode, boolean newFragmentPerHeading) {
        this.lineBreakThreshold = lineBreakThreshold;
        this.isDocumentMode = isDocumentMode;
        this.newFragmentPerHeading = newFragmentPerHeading;
    }

    public static MarkdownInputOptions defaultFragmentOptions() {
        return DEFAULT_FRAGMENT;
    }

    public static MarkdownInputOptions defaultDocumentOptions() {
        return DEFAULT_DOCUMENT;
    }

    public boolean isFragment() {
        return !this.isDocumentMode;
    }

    public boolean isDocument() {
        return this.isDocumentMode;
    }

    public int getLineBreakThreshold() {
        return this.lineBreakThreshold;
    }

    public boolean isNewFragmentPerHeading() {
        return this.newFragmentPerHeading;
    }

    public MarkdownInputOptions enableDocumentMode() {
        return new MarkdownInputOptions(this.lineBreakThreshold, true, this.newFragmentPerHeading);
    }

    public MarkdownInputOptions disableDocumentMode() {
        return new MarkdownInputOptions(this.lineBreakThreshold, false, this.newFragmentPerHeading);
    }

    public MarkdownInputOptions lineBreakThreshold(int threshold) {
        return new MarkdownInputOptions(threshold, this.isDocumentMode, this.newFragmentPerHeading);
    }

    public MarkdownInputOptions newFragmentPerHeading(boolean enabled) {
        return new MarkdownInputOptions(this.lineBreakThreshold, this.isDocumentMode, enabled);
    }
}

