/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.diff;

import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.handler.DiffFilter;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.psml.util.Beta;

@Beta
public final class ShiftLeftFilter
extends DiffFilter<XMLToken> {
    private final List<Operation<XMLToken>> operations = new ArrayList<Operation<XMLToken>>();
    private int lastOperatorCount = 0;
    private Operator lastOperator = Operator.MATCH;
    private int shifted = 0;

    public ShiftLeftFilter(DiffHandler<XMLToken> handler) {
        super(handler);
    }

    public void handle(Operator operator, XMLToken token) throws UncheckedIOException, IllegalStateException {
        if (operator == Operator.MATCH && this.lastOperator != operator && this.lastOperatorCount > 1) {
            this.shifted += this.shiftOperations();
            this.flush();
        }
        if (this.lastOperator != operator) {
            this.lastOperatorCount = 0;
        }
        ++this.lastOperatorCount;
        this.lastOperator = operator;
        this.operations.add((Operation<XMLToken>)new Operation(operator, (Object)token));
    }

    public void end() {
        this.flush();
        this.target.end();
    }

    public int getShifted() {
        return this.shifted;
    }

    private int shiftOperations() {
        int shift = 0;
        int p = this.operations.size() - 1;
        Operation<XMLToken> lastChanged = this.operations.get(p);
        Operation<XMLToken> lastUnchanged = this.operations.get(p - this.lastOperatorCount);
        while (p >= 0 && lastUnchanged.operator() == Operator.MATCH && ((XMLToken)lastChanged.token()).equals((XMLToken)lastUnchanged.token())) {
            if (ShiftLeftFilter.isBalanced(this.operations, p - this.lastOperatorCount + 1, p + 1)) {
                return shift;
            }
            this.operations.set(p, (Operation<XMLToken>)new Operation(lastUnchanged.operator(), (Object)((XMLToken)lastChanged.token())));
            this.operations.set(p - this.lastOperatorCount, (Operation<XMLToken>)new Operation(lastChanged.operator(), (Object)((XMLToken)lastUnchanged.token())));
            ++shift;
            if (--p - this.lastOperatorCount < 0) break;
            lastChanged = this.operations.get(p);
            lastUnchanged = this.operations.get(p - this.lastOperatorCount);
        }
        return shift;
    }

    private void flush() {
        for (Operation<XMLToken> operation : this.operations) {
            this.target.handle(operation.operator(), (Object)((XMLToken)operation.token()));
        }
        this.operations.clear();
    }

    private static boolean isBalanced(List<Operation<XMLToken>> operations, int from, int to) {
        ArrayDeque<XMLToken> stack = new ArrayDeque<XMLToken>();
        for (int i = from; i < to; ++i) {
            XMLToken token = (XMLToken)operations.get(i).token();
            if (token.getType() == XMLTokenType.START_ELEMENT) {
                stack.push(token);
                continue;
            }
            if (token.getType() != XMLTokenType.END_ELEMENT) continue;
            if (stack.isEmpty()) {
                return false;
            }
            if (((XMLToken)stack.pop()).getName().equals(token.getName())) continue;
            return false;
        }
        return stack.isEmpty();
    }
}

