/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.diff;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.action.OperationsBuffer;
import org.pageseeder.diffx.algorithm.MatrixXMLAlgorithm;
import org.pageseeder.diffx.api.DiffAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.handler.XMLEventBalancer;
import org.pageseeder.diffx.similarity.EditSimilarity;
import org.pageseeder.diffx.similarity.ElementSimilarity;
import org.pageseeder.diffx.similarity.Similarity;
import org.pageseeder.diffx.similarity.SimilarityWagnerFischerAlgorithm;
import org.pageseeder.diffx.similarity.StreamSimilarity;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.XMLElement;
import org.pageseeder.diffx.token.impl.XMLEndElement;
import org.pageseeder.diffx.token.impl.XMLStartElement;

@Deprecated
public class GasherbrumIVAlgorithm
implements DiffAlgorithm<XMLToken> {
    private static final Set<String> DEFAULT_BLOCKS = Set.of("heading", "item", "para", "preformat", "row");
    public static final float DEFAULT_SIMILARITY_THRESHOLD = 0.5f;
    public static final double DEFAULT_LENGTH_BOOST_FACTOR = 0.1;
    private float similarityThreshold;
    private boolean hasError = false;
    private Set<StartElementToken> blocks = DEFAULT_BLOCKS.stream().map(XMLStartElement::new).collect(Collectors.toSet());

    public GasherbrumIVAlgorithm() {
        this.similarityThreshold = 0.5f;
    }

    public GasherbrumIVAlgorithm(float similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
    }

    public void setSimilarityThreshold(float similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
    }

    public float getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public void setBlocks(Collection<String> blocks) {
        this.blocks = blocks.stream().map(XMLStartElement::new).collect(Collectors.toSet());
    }

    public boolean hasError() {
        return this.hasError;
    }

    public Set<StartElementToken> getBlocks() {
        return this.blocks;
    }

    public void diff(List<? extends XMLToken> from, List<? extends XMLToken> to, DiffHandler<XMLToken> handler) {
        List<XMLToken> gFrom = this.fold(from);
        List<XMLToken> gTo = this.fold(to);
        OperationsBuffer<XMLToken> buffer = this.diffBySimilarity(gFrom, gTo);
        XMLEventBalancer fixer = new XMLEventBalancer(handler);
        fixer.start();
        this.diffAndUnfold(gFrom, gTo, buffer, (DiffHandler<XMLToken>)fixer);
        fixer.end();
        this.hasError = fixer.hasError();
    }

    private OperationsBuffer<XMLToken> diffBySimilarity(List<XMLToken> from, List<XMLToken> to) {
        SimilarityWagnerFischerAlgorithm algorithm = new SimilarityWagnerFischerAlgorithm((Similarity)new ElementSimilarity((StreamSimilarity)new EditSimilarity(), 0.1), this.similarityThreshold);
        OperationsBuffer buffer = new OperationsBuffer();
        algorithm.diff(from, to, (DiffHandler)buffer);
        return buffer;
    }

    private void diffAndUnfold(List<XMLToken> from, List<XMLToken> to, OperationsBuffer<XMLToken> path, DiffHandler<XMLToken> handler) {
        int i = 0;
        int j = 0;
        for (Operation operation : path.getOperations()) {
            Operator operator = operation.operator();
            XMLToken token = (XMLToken)operation.token();
            if (token.getType() == XMLTokenType.ELEMENT) {
                if (operator == Operator.MATCH) {
                    XMLElement fromElement = (XMLElement)from.get(i);
                    XMLElement toElement = (XMLElement)to.get(j);
                    this.diffElement(fromElement, toElement, operator, handler);
                } else {
                    for (XMLToken t : ((XMLElement)token).tokens()) {
                        handler.handle(operator, (Object)t);
                    }
                }
            } else {
                handler.handle(operator, (Object)token);
            }
            if (operator == Operator.MATCH || operator == Operator.INS) {
                ++j;
            }
            if (operator != Operator.MATCH && operator != Operator.DEL) continue;
            ++i;
        }
    }

    void diffElement(XMLElement from, XMLElement to, Operator operator, DiffHandler<XMLToken> handler) {
        boolean recurse = this.childHasBlock(from, to);
        if (recurse) {
            handler.handle(operator, (Object)from.getStart());
            this.diff(from.getContent(), to.getContent(), handler);
            handler.handle(operator, (Object)from.getEnd());
        } else {
            MatrixXMLAlgorithm matrix = new MatrixXMLAlgorithm();
            matrix.diff(from.tokens(), to.tokens(), handler);
        }
    }

    private List<XMLToken> fold(List<? extends XMLToken> in) {
        ArrayDeque<XMLToken> stack = new ArrayDeque<XMLToken>();
        ArrayList<XMLToken> out = new ArrayList<XMLToken>();
        ArrayList<XMLToken> children = null;
        for (XMLToken xMLToken : in) {
            if (children != null) {
                if (xMLToken.getType() == XMLTokenType.END_ELEMENT && this.isBlock(xMLToken) && stack.size() == 1 && ((XMLToken)stack.peek()).getName().equals(xMLToken.getName())) {
                    XMLStartElement start = (XMLStartElement)stack.pop();
                    XMLEndElement end = (XMLEndElement)xMLToken;
                    out.add((XMLToken)new XMLElement((StartElementToken)start, (EndElementToken)end, children));
                    children = null;
                    continue;
                }
                if (xMLToken.getType() == XMLTokenType.START_ELEMENT) {
                    stack.push(xMLToken);
                } else if (xMLToken.getType() == XMLTokenType.END_ELEMENT) {
                    stack.pop();
                }
                children.add(xMLToken);
                continue;
            }
            if (xMLToken.getType() == XMLTokenType.START_ELEMENT && this.isBlock(xMLToken)) {
                children = new ArrayList<XMLToken>();
                stack.push(xMLToken);
                continue;
            }
            out.add(xMLToken);
        }
        return out;
    }

    private boolean childHasBlock(XMLElement from, XMLElement to) {
        if (from.getContent().size() > 2 && to.getContent().size() > 2) {
            return this.childHasBlock(from) || this.childHasBlock(to);
        }
        return false;
    }

    private boolean childHasBlock(XMLElement element) {
        for (XMLToken t : element.getContent()) {
            if (t.getType() != XMLTokenType.START_ELEMENT || !this.isBlock(t)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlock(XMLToken token) {
        if (token instanceof StartElementToken) {
            return this.blocks.contains(token);
        }
        if (token instanceof EndElementToken) {
            return this.blocks.contains(((EndElementToken)token).getStartElement());
        }
        return false;
    }
}

