/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.utils;

import com.pageseeder.publishapi.utils.ThreadLogger;
import com.pageseeder.publishapi.utils.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ThreadResponseHandler
extends DefaultHandler {
    private String threadid = null;
    private String groupid = null;
    private ThreadLogger.Status threadstatus = null;
    private StringBuilder zip = new StringBuilder();
    private StringBuilder xml = new StringBuilder();
    private boolean inMessage = false;
    private boolean inZip = false;
    private final boolean logsRequest;

    public ThreadResponseHandler(boolean logs) {
        this.logsRequest = logs;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.inMessage || !this.logsRequest) {
            this.xml.append("<").append(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.xml.append(" ").append(attributes.getQName(i)).append("='").append(XMLUtils.escapeForAttribute(attributes.getValue(i))).append("'");
            }
            this.xml.append(">");
        }
        if ("thread".equals(qName)) {
            this.threadid = attributes.getValue("id");
            this.groupid = attributes.getValue("groupid");
            this.threadstatus = ThreadLogger.Status.fromString(attributes.getValue("status"));
        } else if ("zip".equals(qName)) {
            this.inZip = true;
        } else if ("message".equals(qName)) {
            this.inMessage = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("message".equals(qName)) {
            this.inMessage = false;
        } else if ("zip".equals(qName)) {
            this.inZip = false;
        }
        if (this.inMessage || !this.logsRequest) {
            this.xml.append("</").append(qName).append(">");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inMessage || !this.logsRequest) {
            this.xml.append(XMLUtils.escape(new String(ch, start, length)));
        }
        if (this.inZip) {
            this.zip.append(XMLUtils.escape(new String(ch, start, length)));
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.xml.setLength(0);
        this.threadstatus = null;
    }

    boolean isThreadFinished() {
        return this.threadstatus == ThreadLogger.Status.CANCELLED || this.threadstatus == ThreadLogger.Status.FAILED || this.threadstatus == ThreadLogger.Status.COMPLETED;
    }

    public String getThreadID() {
        return this.threadid;
    }

    public String getGroupID() {
        return this.groupid;
    }

    public ThreadLogger.Status getThreadStatus() {
        return this.threadstatus;
    }

    public String getThreadMessage() {
        return this.xml.toString();
    }

    public String getZipFileName() {
        return this.zip.toString();
    }
}

