/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.publish;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.Request;
import com.pageseeder.publishapi.publish.MessageType;
import com.pageseeder.publishapi.publish.PublishLogger;
import com.pageseeder.publishapi.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Publish {
    private final ExternalConfig _config;
    private final String _groupname;
    private final String _project;
    private final String _action;
    private String _documenttype = null;
    private String _loglevel = "info";
    private String _uri = null;
    private int pollingInterval = 5000;
    private PublishLogger logger = null;
    private Map<String, String> params = new HashMap<String, String>();

    public Publish(ExternalConfig config, String group, String project, String action) {
        this._config = config;
        this._groupname = group;
        this._project = project;
        if (!("import".equals(action) || "export".equals(action) || "preview".equals(action) || "publish".equals(action) || "process".equals(action))) {
            throw new IllegalArgumentException("Illegal type " + action);
        }
        this._action = action;
    }

    public void setLogLevel(String level) {
        if (level == null) {
            this._loglevel = "info";
        } else if ("debug".equals(level) || "verbose".equals(level) || "info".equals(level) || "warn".equals(level) || "error".equals(level)) {
            this._loglevel = level;
        } else {
            throw new IllegalArgumentException("Illegal level " + level);
        }
    }

    public void setURI(String uri) {
        this._uri = uri;
    }

    public void setParameter(String name, String value) {
        this.params.put(name, value);
    }

    public void setDocumentType(String documenttype) {
        this._documenttype = documenttype;
    }

    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = this.pollingInterval <= 0 ? 5000 : pollingInterval;
    }

    public void setLogger(PublishLogger logger) {
        this.logger = logger;
    }

    public void publish(String target) throws PageseederException {
        String member = this._config.getUsername();
        if (member == null) {
            throw new PageseederException("No member in the config!");
        }
        Request start = new Request(Publish.buildStartServicePath(member, this._groupname, this._uri), this._config);
        start.addParameter("log-level", this._loglevel);
        start.addParameter("project", this._project);
        start.addParameter("type", this._action);
        start.addParameter("target", target);
        if (this._documenttype != null) {
            start.addParameter("documenttype", this._documenttype);
        }
        for (Map.Entry<String, String> param : this.params.entrySet()) {
            start.addParameter("ps-param-" + param.getKey(), param.getValue());
        }
        start.send();
        PublisherResponseHandler handler = this.parseResponse(start.getResponse());
        while (!Publish.isPublishCompleted(handler.status)) {
            try {
                Thread.sleep(this.pollingInterval);
            }
            catch (InterruptedException ex) {
                if (this.logger != null) {
                    this.logger.log("Failed to wait delay: " + ex.getMessage(), MessageType.ERROR);
                }
                throw new PageseederException("Failed to wait delay", ex);
            }
            Request check = new Request(Publish.buildCheckServicePath(member), this._config);
            check.addParameter("jobid", handler.id);
            check.send();
            handler = this.parseResponse(check.getResponse());
        }
    }

    private PublisherResponseHandler parseResponse(byte[] resp) throws PageseederException {
        PublisherResponseHandler handler = new PublisherResponseHandler(this.logger);
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        XMLUtils.parse(new ByteArrayInputStream(resp), handler, errors, warnings);
        if (this.logger != null) {
            for (String error : errors) {
                this.logger.log(error, MessageType.ERROR);
            }
            for (String warning : warnings) {
                this.logger.log(warning, MessageType.WARN);
            }
        }
        return handler;
    }

    private static String buildStartServicePath(String member, String group, String uri) throws PageseederException {
        try {
            return "/service/members/" + URLEncoder.encode(member, "UTF-8").replace("+", "%20") + "/groups/" + group + (String)(uri != null ? "/uris/" + uri : "") + "/publish/start";
        }
        catch (UnsupportedEncodingException ex) {
            throw new PageseederException(ex.getMessage());
        }
    }

    private static String buildCheckServicePath(String member) throws PageseederException {
        try {
            return "/service/members/" + URLEncoder.encode(member, "UTF-8").replace("+", "%20") + "/publish/check";
        }
        catch (UnsupportedEncodingException ex) {
            throw new PageseederException(ex.getMessage());
        }
    }

    private static boolean isPublishCompleted(String status) {
        return "complete".equals(status) || "cancel".equals(status) || "error".equals(status) || "fail".equals(status);
    }

    private static class PublisherResponseHandler
    extends DefaultHandler {
        private final PublishLogger logger;
        private String id = null;
        private String status = null;
        private XMLStringWriter messageContent = null;
        private MessageType messageType = null;
        private StringBuilder ch = null;

        public PublisherResponseHandler(PublishLogger l) {
            this.logger = l;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.messageContent != null) {
                this.messageContent.openElement(uri, localName, true);
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.messageContent.attribute(atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                }
            } else if ("publish".equals(qName)) {
                this.id = atts.getValue("id");
            } else if ("status".equals(qName)) {
                this.ch = new StringBuilder();
            } else if ("message".equals(qName) && !"true".equals(atts.getValue("logged")) && this.logger != null) {
                this.messageType = MessageType.fromString(atts.getValue("type"));
                if (this.messageType != null) {
                    this.messageContent = new XMLStringWriter(XML.NamespaceAware.Yes);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!"message".equals(qName) && this.messageContent != null) {
                this.messageContent.closeElement();
                return;
            }
            if ("message".equals(qName) && this.messageContent != null && this.messageType != null) {
                String msg = this.messageContent.toString().trim();
                if (!msg.isEmpty()) {
                    this.logger.log(msg, this.messageType);
                }
                this.messageContent = null;
                this.messageType = null;
            } else if ("status".equals(qName) && this.ch != null) {
                this.status = this.ch.toString();
                this.ch = null;
            }
        }

        @Override
        public void characters(char[] str, int start, int length) throws SAXException {
            if (this.ch != null) {
                this.ch.append(str, start, length);
            } else if (this.messageContent != null) {
                this.messageContent.writeXML(str, start, length);
            }
        }
    }
}

