/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.oauth;

import com.pageseeder.publishapi.oauth.OAuthUtils;
import com.pageseeder.publishapi.oauth.TokenResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class TokenRequest {
    private static final String TOKEN_ENDPOINT = "/oauth/token";
    private final String _url;
    private final Map<String, String> _parameters;
    private final String _clientId;
    private final String _clientSecret;

    private TokenRequest(String url, Map<String, String> parameters, String clientId, String clientSecret) {
        this._url = url;
        this._parameters = parameters;
        this._clientId = clientId;
        this._clientSecret = clientSecret;
    }

    public static TokenRequest newClientCredentials(String clientId, String clientSecret, String urlBase) {
        Objects.requireNonNull(clientId, "The client credentials are required (ID)");
        Objects.requireNonNull(clientSecret, "The client credentials are required (secret)");
        Objects.requireNonNull(urlBase, "The url base is required");
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(3);
        parameters.put("grant_type", "client_credentials");
        return new TokenRequest(urlBase + TOKEN_ENDPOINT, parameters, clientId, clientSecret);
    }

    public TokenResponse post() {
        try {
            URL url = new URL(this._url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            String authorization = Base64.getEncoder().encodeToString((this._clientId + ":" + this._clientSecret).getBytes(StandardCharsets.UTF_8));
            connection.addRequestProperty("Authorization", "Basic " + authorization);
            connection.setRequestMethod("POST");
            byte[] parameters = OAuthUtils.encodeParameters(this._parameters).getBytes(StandardCharsets.UTF_8);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            connection.setRequestProperty("Content-Length", Integer.toString(parameters.length));
            connection.setDoInput(true);
            connection.setDoOutput(true);
            try (OutputStream post = connection.getOutputStream();){
                post.write(parameters);
                post.flush();
            }
            return TokenResponse.consume(connection, this._clientSecret);
        }
        catch (ConnectException ex) {
            return TokenResponse.error("connection_error", ex.getMessage());
        }
        catch (ProtocolException ex) {
            return TokenResponse.error("protocol_error", ex.getMessage());
        }
        catch (IOException ex) {
            return TokenResponse.error("io_error", ex.getMessage());
        }
    }

    public String toString() {
        return "POST " + this._url + "?" + OAuthUtils.encodeParameters(this._parameters).replaceAll("password=([^&]+)", "password=******");
    }
}

