/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.ant.Parameter;
import com.pageseeder.publishapi.publish.MessageType;
import com.pageseeder.publishapi.publish.Publish;
import com.pageseeder.publishapi.publish.PublishLogger;
import com.pageseeder.publishapi.utils.ANTUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PublishTask
extends Task
implements PublishLogger {
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private String group;
    private String publishProject;
    private String type;
    private String publishTarget;
    private String uri;
    private String documenttype;
    private String loglevel;
    private boolean failOnError = true;
    private int pollinginterval = 5000;
    private String config = "default";

    public void setConfig(String cfg) {
        this.config = cfg;
    }

    public void addParameter(Parameter param) {
        this.parameters.add(param);
    }

    public void setProject(String proj) {
        this.publishProject = proj;
    }

    public void setGroup(String _group) {
        this.group = _group;
    }

    public void setType(String thetype) {
        this.type = thetype;
    }

    public void setTarget(String thetarget) {
        this.publishTarget = thetarget;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setDocumenttype(String doctype) {
        this.documenttype = doctype;
    }

    public void setLogLevel(String level) {
        this.loglevel = level;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setPollinginterval(int ms) {
        this.pollinginterval = ms;
    }

    public void execute() throws BuildException {
        if (this.group == null) {
            throw new BuildException("Please specify a group name.");
        }
        if (this.publishProject == null) {
            throw new BuildException("Please specify a project for the script.");
        }
        if (this.type == null) {
            throw new BuildException("Please specify a type for the script.");
        }
        if (!("import".equals(this.type) || "export".equals(this.type) || "publish".equals(this.type) || "process".equals(this.type))) {
            throw new BuildException("Please specify a valid type for the script (export|publish|process).");
        }
        if (!(this.loglevel == null || "debug".equals(this.loglevel) || "verbose".equals(this.loglevel) || "info".equals(this.loglevel) || "warn".equals(this.loglevel) || "error".equals(this.loglevel))) {
            throw new BuildException("Please specify a valid log level (debug|verbose|info|warn|error)");
        }
        try {
            ExternalConfig config = ANTUtils.buildConfig(this.getProject(), this.config);
            Publish publish = new Publish(config, this.group, this.publishProject, this.type);
            publish.setLogger(this);
            publish.setLogLevel(this.loglevel);
            publish.setPollingInterval(this.pollinginterval);
            publish.setDocumentType(this.documenttype);
            publish.setURI(this.uri);
            for (Parameter param : this.parameters) {
                publish.setParameter(param.getName(), param.getValue());
            }
            publish.publish(this.publishTarget);
        }
        catch (PageseederException ex) {
            if (this.failOnError) {
                this.log("Failed to publish: " + ex.getMessage(), 0);
                throw new BuildException("Error executing publish: " + ex.getMessage(), (Throwable)ex);
            }
            this.log("Failed to publish: " + ex.getMessage(), 1);
        }
        catch (Exception ex) {
            if (this.failOnError) {
                this.log("Failed to publish: " + ex.getMessage(), 0);
                throw new BuildException("Error executing publish: " + ex.getMessage(), (Throwable)ex);
            }
            this.log("Failed to publish: " + ex.getMessage(), 1);
        }
    }

    @Override
    public void log(String message, MessageType type) {
        if (this.failOnError && (type == MessageType.ERROR || type == MessageType.FAIL)) {
            throw new BuildException("Remote error executing publish: " + message);
        }
        this.log("[remote] " + message, type.getPriority());
    }
}

