/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.MultiPartRequest;
import com.pageseeder.publishapi.utils.ANTUtils;
import java.io.File;
import java.io.FileInputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class LoadingZonePutTask
extends Task {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private String groupName;
    private String folder = "";
    private String config = "default";

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setGroup(String group) {
        this.groupName = group;
    }

    public void setFolder(String f) {
        while (((String)f).startsWith("/")) {
            f = ((String)f).substring(1);
        }
        if (!((String)f).isEmpty() && !((String)f).endsWith("/")) {
            f = (String)f + "/";
        }
        this.folder = f;
    }

    public void setConfig(String cfg) {
        this.config = cfg;
    }

    public void execute() throws BuildException {
        if (this.filesets.size() == 0) {
            throw new BuildException("No target directory/files is specfified. Please specify the embedded '<fileset>' argument.");
        }
        if (this.groupName == null) {
            throw new BuildException("Please specify a group name.");
        }
        try {
            HashMap<CallSite, File> toUpload = new HashMap<CallSite, File>();
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fs = this.filesets.get(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File dir = fs.getDir(this.getProject());
                String[] files = ds.getIncludedFiles();
                for (String file2 : files) {
                    String file = file2.replace('\\', '/');
                    File f = new File(dir, file);
                    if (!f.exists()) continue;
                    toUpload.put((CallSite)((Object)(this.folder + file)), f);
                }
            }
            if (toUpload.isEmpty()) {
                throw new BuildException("No files to upload");
            }
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("group", this.groupName);
            ExternalConfig psconfig = ANTUtils.buildConfig(this.getProject(), this.config);
            MultiPartRequest put = new MultiPartRequest(psconfig, "upload", params);
            Object files_uploaded = "";
            int fileNumber = 1;
            for (String filepath : toUpload.keySet()) {
                File f = (File)toUpload.get(filepath);
                if (filepath.indexOf(47) != -1) {
                    String folder = filepath.substring(0, filepath.lastIndexOf(47));
                    put.addPart(folder.getBytes("UTF-8"), "UTF-8", "text/plain", Collections.singletonMap("Content-Disposition", "form-data; name=\"folder-" + fileNumber + "\""));
                }
                try (FileInputStream in = new FileInputStream(f);){
                    put.addPart(in, "UTF-8", "text/plain", Collections.singletonMap("Content-Disposition", "form-data; name=\"file-" + fileNumber++ + "\"; filename=\"" + f.getName() + "\""));
                }
                files_uploaded = (String)files_uploaded + f.getName();
                files_uploaded = (String)files_uploaded + ", ";
            }
            this.log("The following files have been sent: " + ((String)files_uploaded).replace(", $", ""));
            put.getResponse();
        }
        catch (Exception e) {
            if (!(e instanceof BuildException)) {
                e.printStackTrace(System.out);
            }
            throw new BuildException("Error executing Upload: " + e.getMessage());
        }
    }
}

