/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.LoadingZoneDelete;
import com.pageseeder.publishapi.utils.ANTUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class LoadingZoneDeleteTask
extends Task {
    private String path = null;
    private String paths = null;
    private String config = "default";
    private String group = null;

    public void setPath(String _path) {
        this.path = _path;
    }

    public void setPaths(String _paths) {
        this.paths = _paths;
    }

    public void setConfig(String cfg) {
        this.config = cfg;
    }

    public void setGroup(String g) {
        this.group = g;
    }

    public void execute() throws BuildException {
        List<Object> errors;
        if (this.path == null && this.paths == null) {
            throw new BuildException("Path to download is not specified.");
        }
        if (this.group == null) {
            throw new BuildException("Group is not specified.");
        }
        if (this.path != null) {
            errors = this.deletePath(this.path);
        } else {
            errors = new ArrayList();
            String[] paths = this.paths.split("\\|");
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i].endsWith("/")) {
                    this.log("Path " + paths[i] + " is ignored as it points to a folder.", 1);
                    continue;
                }
                errors.addAll(this.deletePath(paths[i]));
            }
        }
        while (!errors.isEmpty()) {
            this.log(((String)errors.remove(0)).toString(), 0);
        }
    }

    private List<String> deletePath(String thepath) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            LoadingZoneDelete lzd = new LoadingZoneDelete(thepath, this.group, null, ANTUtils.buildConfig(this.getProject(), this.config));
            lzd.delete();
        }
        catch (Exception e) {
            errors.add("Failed to delete the path " + thepath + ": " + e.getMessage());
        }
        return errors;
    }
}

