/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.ant.AntLogger;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.pageseeder.diffx.config.TextGranularity;
import org.pageseeder.diffx.config.WhiteSpaceProcessing;
import org.pageseeder.psml.diff.Diff;
import org.pageseeder.psml.diff.DiffException;
import org.pageseeder.psml.diff.DiffFiles;
import org.slf4j.Logger;

public final class DiffTask
extends Task {
    private String src = null;
    private String dest = null;
    private String maxEvents = null;
    private String whiteSpaceProcessing = null;
    private String textGranularity = null;
    private DiffFiles filesFilter = null;

    public void setSrc(String source) {
        this.src = source;
    }

    public void setDest(String destination) {
        this.dest = destination;
    }

    public void setWhitespace(String whitespace) {
        this.whiteSpaceProcessing = whitespace;
    }

    public void setGranularity(String granularity) {
        this.textGranularity = granularity;
    }

    public void setMaxevents(String maxevents) {
        this.maxEvents = maxevents;
    }

    public DiffFiles createFiles() {
        this.filesFilter = new DiffFiles();
        return this.filesFilter;
    }

    public void execute() throws BuildException {
        if (this.src == null) {
            throw new BuildException("Src must be specified");
        }
        File source = new File(this.src);
        if (!source.exists()) {
            source = new File(this.getProject().getBaseDir(), this.src);
        }
        if (!source.exists()) {
            throw new BuildException("Invalid src location " + this.src);
        }
        if (this.dest == null) {
            throw new BuildException("Dest must be specified");
        }
        File destination = new File(this.dest);
        if (!destination.exists()) {
            destination.mkdirs();
        }
        if (!destination.exists()) {
            throw new BuildException("Failed to create destination folder " + this.dest);
        }
        if (!destination.isDirectory()) {
            throw new BuildException("Invalid destination folder " + this.dest);
        }
        Logger logger = AntLogger.newInstance(this);
        Diff diff = new Diff();
        diff.setLogger(logger);
        diff.setSrc(source);
        diff.setDest(destination);
        if (this.filesFilter != null) {
            diff.setFilesMatcher(this.filesFilter.buildMatcher());
        }
        if (this.maxEvents == null) {
            diff.setMaxEvents(4000000);
        } else {
            try {
                int max = Integer.parseInt(this.maxEvents);
                diff.setMaxEvents(max);
            }
            catch (NumberFormatException ex) {
                throw new BuildException("Invalid maxevents " + this.maxEvents);
            }
        }
        if (this.whiteSpaceProcessing == null || "preserve".equals(this.whiteSpaceProcessing)) {
            diff.setWhiteSpaceProcessing(WhiteSpaceProcessing.PRESERVE);
        } else if ("compare".equals(this.whiteSpaceProcessing)) {
            diff.setWhiteSpaceProcessing(WhiteSpaceProcessing.COMPARE);
        } else if ("ignore".equals(this.whiteSpaceProcessing)) {
            diff.setWhiteSpaceProcessing(WhiteSpaceProcessing.IGNORE);
        } else {
            throw new BuildException("Invalid whitespace " + this.whiteSpaceProcessing);
        }
        if (this.textGranularity == null || "space_word".equals(this.textGranularity)) {
            diff.setGranularity(TextGranularity.SPACE_WORD);
        } else if ("word".equals(this.textGranularity)) {
            diff.setGranularity(TextGranularity.WORD);
        } else if ("character".equals(this.textGranularity)) {
            diff.setGranularity(TextGranularity.CHARACTER);
        } else if ("text".equals(this.textGranularity)) {
            diff.setGranularity(TextGranularity.TEXT);
        } else {
            throw new BuildException("Invalid granularity " + this.textGranularity);
        }
        try {
            diff.addDiffElements(false);
        }
        catch (DiffException ex) {
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
    }
}

