/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.MultiPartRequest;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.Request;
import com.pageseeder.publishapi.ant.Notification;
import com.pageseeder.publishapi.ant.Workflow;
import com.pageseeder.publishapi.utils.MD5;
import com.pageseeder.publishapi.utils.ThreadLogger;
import com.pageseeder.publishapi.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Upload
extends MultiPartRequest {
    private static final String UPLOAD_SERVLET = "upload";
    private int fileNumber = 1;
    private final String uploadID;
    private final String xlinkID;
    private final String groupName;
    private final String destination;
    private final Map<String, RequestElement> elements = new HashMap<String, RequestElement>();
    private RequestElement mediatypeElement = null;
    private final StringBuilder detailsXML = new StringBuilder();
    private final StringBuilder notificationXML = new StringBuilder();
    private final StringBuilder workflowXML = new StringBuilder();
    private ThreadLogger uploadLogger = null;
    private long pollingInterval = 5000L;
    private List<String> pathsToUnzip = null;
    private boolean deleteOriginalZip = false;
    private boolean loadCreatedURIs = true;

    public Upload(ExternalConfig config, String groupname, String folder) throws PageseederException {
        this(config, groupname, folder, null);
    }

    public Upload(ExternalConfig config, String groupname, String folder, String xlinkid) throws PageseederException {
        super(config, UPLOAD_SERVLET);
        this.groupName = groupname;
        this.destination = folder;
        this.xlinkID = xlinkid;
        this.uploadID = this.xlinkID == null ? "externalapi-" + MD5.hash(System.currentTimeMillis() + 45L + System.nanoTime() + 45L + folder) : null;
        this.addParameter("group", groupname);
        if (this.uploadID != null) {
            this.addParameter("uploadid", this.uploadID);
        }
        if (this.xlinkID != null) {
            this.addParameter("xlinkid", this.xlinkID);
        }
        this.connect(true, true, 16384);
    }

    public void setNotification(Notification notification) {
        if (notification == null || notification.getSubject() == null || notification.getContent() == null) {
            return;
        }
        this.notificationXML.append("<message subject='").append(XMLUtils.escapeForAttribute(notification.getSubject()));
        this.notificationXML.append("' notification='").append(notification.getNotify()).append("'");
        if (notification.getLabels() != null) {
            this.notificationXML.append(" labels='").append(notification.getLabels()).append("'");
        }
        this.notificationXML.append(">").append(XMLUtils.escape(notification.getContent())).append("</message>");
    }

    public void setWorkflow(Workflow workflow) {
        if (workflow == null || workflow.getStatus() == null) {
            return;
        }
        this.workflowXML.append("<workflow status='").append(XMLUtils.escapeForAttribute(workflow.getStatus()));
        this.workflowXML.append("' notification='").append(workflow.getNotify()).append("'");
        if (workflow.getPriority() != null) {
            this.workflowXML.append(" priority='").append(workflow.getPriority()).append("'");
        }
        if (workflow.getDue() != null) {
            this.workflowXML.append(" duedate='").append(workflow.getDue()).append("'");
        }
        if (workflow.getAssignto() != null) {
            this.workflowXML.append(" assignto='").append(workflow.getAssignto()).append("'");
        }
        if (workflow.getLabels() != null) {
            this.workflowXML.append(" labels='").append(workflow.getLabels()).append("'");
        }
        if (workflow.getContent() != null) {
            this.workflowXML.append(">").append(XMLUtils.escape(workflow.getContent())).append("</workflow>");
        } else {
            this.workflowXML.append("/>");
        }
    }

    public void setUploadDetails(boolean overwrite, boolean overwriteProperties, boolean resolve, boolean validate, boolean index, boolean unzip, boolean deleteZip) {
        if (unzip) {
            this.pathsToUnzip = new ArrayList<String>();
        }
        this.deleteOriginalZip = deleteZip;
        if (!validate) {
            this.detailsXML.append("<validate>").append(validate).append("</validate>");
        }
        this.detailsXML.append("<overwrite include-properties=\"").append(overwriteProperties).append("\">");
        this.detailsXML.append(overwrite).append("</overwrite>");
        this.detailsXML.append("<createxrefs>").append(resolve).append("</createxrefs>");
        this.detailsXML.append("<index>").append(index).append("</index>");
    }

    public void setLoadCreatedURIs(boolean loadCreatedURIs) {
        this.loadCreatedURIs = loadCreatedURIs;
    }

    public void setPollingInterval(long ms) {
        this.pollingInterval = ms;
    }

    public void setUploadLogger(ThreadLogger uplog) {
        this.uploadLogger = uplog;
    }

    public void addFile(File file, String encoding, String filename, String usertitle, String documentID, String[] labels) throws PageseederException, IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.addPart(in, encoding, "text/plain", Collections.singletonMap("Content-Disposition", "form-data; name=\"file-" + this.fileNumber + "\"; filename=\"" + filename + "\""));
        }
        boolean isZip = filename.toLowerCase().endsWith(".zip");
        if (!isZip || !this.deleteOriginalZip) {
            RequestElement reqEl = new RequestElement();
            reqEl.filename = filename;
            reqEl.docid = documentID == null || documentID.length() == 0 ? null : documentID;
            reqEl.labels = labels;
            reqEl.usertitle = usertitle == null || usertitle.length() == 0 ? null : usertitle;
            this.elements.put(filename, reqEl);
        }
        this.mediatypeElement = new RequestElement();
        this.mediatypeElement.file = false;
        this.mediatypeElement.docid = documentID == null || documentID.length() == 0 ? null : documentID;
        this.mediatypeElement.labels = labels;
        this.mediatypeElement.usertitle = usertitle == null || usertitle.length() == 0 ? null : usertitle;
        ++this.fileNumber;
    }

    @Override
    public String getResponse() throws PageseederException {
        Object request;
        UploadServletHandler handler;
        String resp = super.getResponse();
        try {
            handler = UploadServletHandler.readResponse(resp, this.pathsToUnzip, this.elements);
        }
        catch (IOException e) {
            throw new PageseederException("Failed to read response from Upload Servlet: " + e.getLocalizedMessage(), e);
        }
        UploadLogger logger = new UploadLogger(this.uploadLogger);
        if (handler.getMessage() != null) {
            logger.addStatus(ThreadLogger.Status.WARNING, "<message>" + XMLUtils.escape(handler.getMessage()) + "</message>");
        }
        if (this.xlinkID != null) {
            return resp;
        }
        ExternalConfig cfg = this.getConfig();
        boolean unzipped = false;
        while (this.pathsToUnzip != null && !this.pathsToUnzip.isEmpty()) {
            String path = this.pathsToUnzip.remove(0);
            request = new Request("/service/members/" + handler.getMemberID() + "/groups/" + this.groupName + "/loadingzone/unzip", cfg);
            ((Request)request).setThreadHandlingDetails(1000L, null);
            ((Request)request).addParameter("path", path);
            ((Request)request).addParameter("uploadid", this.uploadID);
            ((Request)request).addParameter("deleteoriginal", this.deleteOriginalZip ? "true" : "false");
            ((Request)request).setHTTPMethod("POST");
            ((Request)request).send();
            ((Request)request).getResponse();
            unzipped = true;
        }
        StringBuilder xmlRequest = new StringBuilder("<upload-request version=\"3.0\"><files>");
        if (unzipped) {
            this.mediatypeElement.toXML(xmlRequest);
            xmlRequest.append("</files>").append((CharSequence)this.detailsXML);
        } else {
            for (RequestElement el : this.elements.values()) {
                el.toXML(xmlRequest);
            }
            xmlRequest.append("</files>").append((CharSequence)this.detailsXML);
        }
        xmlRequest.append((CharSequence)this.notificationXML);
        xmlRequest.append((CharSequence)this.workflowXML);
        xmlRequest.append("</upload-request>");
        request = new Request("/service/members/" + handler.getMemberID() + "/groups/" + this.groupName + "/loadingzone/start", cfg);
        ((Request)request).setThreadHandlingDetails(this.pollingInterval, logger);
        ((Request)request).addParameter("group", this.groupName);
        if (this.destination != null && (this.destination.startsWith("http://") || this.destination.startsWith("https://"))) {
            ((Request)request).addParameter("url", this.destination);
        } else {
            ((Request)request).addParameter("folder", this.destination);
        }
        ((Request)request).addParameter("uploadid", this.uploadID);
        ((Request)request).addParameter("xmlspec", xmlRequest.toString());
        ((Request)request).setHTTPMethod("POST");
        ((Request)request).send();
        ((Request)request).getResponse();
        if (this.loadCreatedURIs && logger.wasSuccessful()) {
            Request urisReq = new Request("/service/members/" + handler.getMemberID() + "/groups/" + this.groupName + "/loadingzone/uris", cfg);
            urisReq.addParameter("max", "-1");
            urisReq.addParameter("uploadid", this.uploadID);
            urisReq.send();
            return urisReq.getResponseAsString();
        }
        return logger.getFinalResponse();
    }

    private static final class UploadServletHandler
    extends DefaultHandler {
        private final List<String> toUnzip;
        private final Map<String, RequestElement> elements;
        private String memberID = null;
        private final StringBuilder message = new StringBuilder();

        public UploadServletHandler(List<String> pathsToUnzip, Map<String, RequestElement> els) {
            this.toUnzip = pathsToUnzip;
            this.elements = els;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (Upload.UPLOAD_SERVLET.equals(qName)) {
                this.memberID = attributes.getValue("member");
            } else if ("file".equals(qName)) {
                String path = attributes.getValue("path");
                String original = attributes.getValue("original");
                if (path != null && original != null && !path.equals(original)) {
                    this.message.append("File " + original + " was renamed to " + path);
                    RequestElement el = this.elements.get(original);
                    if (el != null) {
                        el.filename = path;
                    }
                    if (el != null && el.usertitle == null) {
                        el.usertitle = original;
                    }
                }
                if ("zip".equalsIgnoreCase(attributes.getValue("extension")) && this.toUnzip != null && path != null) {
                    this.toUnzip.add(path);
                }
            }
        }

        public String getMemberID() {
            return this.memberID;
        }

        public String getMessage() {
            return this.message.length() == 0 ? null : this.message.toString();
        }

        public static UploadServletHandler readResponse(String response, List<String> paths, Map<String, RequestElement> els) throws IOException {
            UploadServletHandler handler = new UploadServletHandler(paths, els);
            try {
                SAXParserFactory factory = XMLUtils.safeSAXParserFactory();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                XMLReader reader = factory.newSAXParser().getXMLReader();
                reader.setContentHandler(handler);
                reader.parse(new InputSource(new ByteArrayInputStream(response.getBytes("UTF-8"))));
            }
            catch (ParserConfigurationException ex) {
                throw new IOException("Could not configure SAX parser.");
            }
            catch (SAXException ex) {
                throw new IOException("Error while parsing: " + ex.getMessage());
            }
            return handler;
        }
    }

    private static class UploadLogger
    implements ThreadLogger {
        private String status = null;
        private String message = null;
        private boolean hasWarning = false;
        private final ThreadLogger logger;

        public UploadLogger(ThreadLogger log) {
            this.logger = log;
        }

        @Override
        public void addStatus(ThreadLogger.Status status, String msg) {
            if (this.logger != null) {
                this.logger.addStatus(status, msg);
            }
            if (status == ThreadLogger.Status.WARNING) {
                this.hasWarning = true;
            } else if (status == ThreadLogger.Status.COMPLETED) {
                String string = this.status = this.hasWarning || msg.indexOf("warning") != -1 ? "success-message" : "success-reload";
                if (this.message != null) {
                    return;
                }
            } else if (status == ThreadLogger.Status.CANCELLED) {
                this.status = "cancelled";
            } else if (status == ThreadLogger.Status.FAILED) {
                this.status = "error";
            } else if (status != ThreadLogger.Status.ERROR) {
                return;
            }
            this.message = msg;
        }

        @Override
        public void complete() {
            if (this.logger != null) {
                this.logger.complete();
            }
            if (this.status == null) {
                this.status = "unknown";
                this.message = "No status was detected.";
            }
        }

        @Override
        public String getFinalResponse() {
            Object resp;
            if (this.logger != null && (resp = this.logger.getFinalResponse()) != null) {
                return resp;
            }
            resp = "<status>" + this.status + "</status>";
            if (this.message != null) {
                resp = (String)resp + "<message>" + this.message + "</message>";
            }
            return "<root>" + (String)resp + "</root>";
        }

        @Override
        public void setThreadID(String threadid) {
            this.logger.setThreadID(threadid);
        }

        @Override
        public String getThreadID() {
            return this.logger.getThreadID();
        }

        public boolean wasSuccessful() {
            return this.status != null && this.status.startsWith("success");
        }
    }

    private static final class RequestElement {
        private boolean file = true;
        private String filename = null;
        private String usertitle = null;
        private String docid = null;
        private String[] labels = null;

        private RequestElement() {
        }

        public void toXML(StringBuilder xml) {
            xml.append("<").append(this.file ? "file" : "mediatype");
            if (this.filename != null) {
                xml.append(" path='").append(XMLUtils.escapeForAttribute(this.filename)).append("'");
            } else {
                xml.append(" value='all'");
            }
            if (this.usertitle != null && this.usertitle.length() > 0) {
                xml.append(" title='").append(XMLUtils.escapeForAttribute(this.usertitle)).append("'");
            }
            if (this.labels != null && this.labels.length > 0) {
                Object labs = "";
                for (String label : this.labels) {
                    labs = (String)labs + "," + label;
                }
                xml.append(" labels='").append(XMLUtils.escapeForAttribute(((String)labs).substring(1))).append("'");
            }
            if (this.docid != null && this.docid.length() > 0) {
                xml.append(" docid='").append(XMLUtils.escapeForAttribute(this.docid)).append("'");
            }
            xml.append(" />");
        }
    }
}

