/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.utils.ResponseHandler;
import com.pageseeder.publishapi.utils.ThreadLogger;
import com.pageseeder.publishapi.utils.ThreadPoller;
import com.pageseeder.publishapi.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request {
    private static final Logger LOGGER = LoggerFactory.getLogger(Request.class);
    private final ExternalConfig _config;
    private final String _path;
    private final Map<String, String> _parameters;
    private long pollingIntervalMs = 2000L;
    private ThreadLogger threadLogger = null;
    private HttpURLConnection connection;
    private String responseContentType = null;
    private String responseContentEncoding = null;
    private String httpMethod = "GET";
    private boolean followRedirects = true;

    public Request(String path, ExternalConfig cfg) {
        this._path = path;
        this._config = cfg;
        this._parameters = new Hashtable<String, String>();
    }

    public ExternalConfig getConfig() {
        return this._config;
    }

    public void setFollowRedirects(boolean b) {
        if (this.connection != null) {
            throw new IllegalStateException("Too late, already connected to the PS server!");
        }
        this.followRedirects = b;
    }

    public void setHTTPMethod(String method) {
        if (this.connection != null) {
            throw new IllegalStateException("Too late, already connected to the PS server!");
        }
        this.httpMethod = method == null ? "GET" : method;
    }

    public void addParameter(String pname, String pvalue) {
        if (this.connection != null) {
            throw new IllegalStateException("Too late, already connected to the PS server!");
        }
        if (pname == null || pvalue == null) {
            return;
        }
        this._parameters.put(pname, pvalue);
    }

    protected Iterator<String> getParameterNames() {
        return this._parameters.keySet().iterator();
    }

    public String getParameter(String name) {
        return this._parameters.get(name);
    }

    public void setThreadHandlingDetails(long milliseconds, ThreadLogger logger) {
        this.pollingIntervalMs = milliseconds;
        this.threadLogger = logger;
    }

    private boolean isPost() {
        return "POST".equals(this.httpMethod) || "PATCH".equals(this.httpMethod);
    }

    public void send() throws PageseederException {
        if (this.connection != null) {
            throw new IllegalStateException("Too late, already connected to the PS server!");
        }
        StringBuilder path = new StringBuilder(this._path);
        try {
            if (!this.isPost()) {
                if (this._config.getJSessionID() == null && this._config.getUsername() != null && this._config.getPassword() != null) {
                    this._parameters.put("username", this._config.getUsername());
                    this._parameters.put("password", this._config.getPassword());
                }
                Iterator<String> params = this.getParameterNames();
                while (params.hasNext()) {
                    String pname = params.next();
                    path.append(Utils.getUrlParamSeparator(path.toString())).append(pname).append('=').append(URLEncoder.encode(this.getParameter(pname), "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException params) {
            // empty catch block
        }
        String host = this._config.getHost();
        String scheme = this._config.getScheme() != null ? this._config.getScheme() : "http";
        int port = this._config.getPort();
        if (path.charAt(0) != '/') {
            path.insert(0, '/');
        }
        String url = scheme + "://" + host + ":" + port + this._config.getPSPrefix() + path.toString();
        try {
            this.connectToUrl(url);
        }
        catch (IOException e) {
            String msg = "Error connecting to " + Utils.removePasswordJsessionid(url) + " : " + Utils.removePasswordJsessionid(e.getMessage());
            LOGGER.error(msg);
            throw new PageseederException(msg, e);
        }
    }

    private void connectToUrl(String urlString) throws IOException, PageseederException {
        URL url = new URL(urlString);
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setDoOutput(true);
        this.connection.setInstanceFollowRedirects(this.followRedirects);
        if ("PATCH".equals(this.httpMethod)) {
            this.connection.setRequestMethod("POST");
            this.connection.setRequestProperty("X-HTTP-Method-Override", "PATCH");
        } else {
            this.connection.setRequestMethod(this.httpMethod);
        }
        this.connection.setRequestProperty("User-Agent", "Pageseeder External API " + Request.class.getPackage().getImplementationVersion());
        if (this.isPost()) {
            this.connection.setDoInput(true);
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        }
        if (this._config.getUserToken() != null) {
            this.connection.setRequestProperty("Authorization", "Bearer " + this._config.getUserToken());
        } else if (this._config.getJSessionID() != null) {
            this.connection.setRequestProperty("Cookie", "JSESSIONID=" + this._config.getJSessionID());
            if (this._config.getAntiCSRFToken() != null) {
                this.connection.setRequestProperty("Anti-CSRF-Token", this._config.getAntiCSRFToken());
            }
        }
        this.connection.connect();
        if (this.isPost()) {
            StringBuilder contents = new StringBuilder();
            try {
                if (this._config.getJSessionID() == null && this._config.getUsername() != null && this._config.getPassword() != null) {
                    contents.append("&username=").append(URLEncoder.encode(this._config.getUsername(), "UTF-8"));
                    contents.append("&password=").append(URLEncoder.encode(this._config.getPassword(), "UTF-8"));
                }
                Iterator<String> params = this.getParameterNames();
                while (params.hasNext()) {
                    String pname = params.next();
                    contents.append("&").append(pname).append("=").append(URLEncoder.encode(this.getParameter(pname), "UTF-8"));
                }
                if (contents.length() != 0) {
                    OutputStream dout = this.connection.getOutputStream();
                    dout.write(contents.substring(1).getBytes("UTF-8"));
                    dout.flush();
                    dout.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error writing contents of POST request", (Throwable)ex);
                throw new PageseederException("Error writing contents of POST request: " + Utils.removePasswordJsessionid(ex.getMessage()), ex);
            }
        }
    }

    public void writeAllContent(String content, String encoding) throws PageseederException {
        try {
            this.writeAllContent(new ByteArrayInputStream(content.getBytes(encoding)));
        }
        catch (UnsupportedEncodingException e) {
            throw new PageseederException("Invalid Encoding " + encoding, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAllContent(InputStream in) throws PageseederException {
        if (this.connection == null) {
            throw new IllegalStateException("Cannot write before the connection has been established!");
        }
        if (!"POST".equalsIgnoreCase(this.httpMethod) && !"PUT".equals(this.httpMethod)) {
            throw new IllegalStateException("Only POST and PUT method allow input.");
        }
        try {
            OutputStream os = this.connection.getOutputStream();
            byte[] buffer = new byte[4096];
            try {
                int read;
                while ((read = in.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
            }
            finally {
                os.close();
                in.close();
            }
        }
        catch (IOException ex) {
            throw new PageseederException("Failed to write to connection: " + ex.getMessage(), ex);
        }
    }

    public String getResponseAsString() throws PageseederException {
        return this.getResponseAsString(null);
    }

    public String getResponseAsString(Map<String, List<String>> headers) throws PageseederException {
        byte[] data = this.getResponse(headers, null);
        if (data != null && this.isTextResponse()) {
            try {
                return new String(data, this.responseContentEncoding == null ? "UTF-8" : this.responseContentEncoding);
            }
            catch (UnsupportedEncodingException ex) {
                LOGGER.error("Invalid character encoding " + this.responseContentEncoding, (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    public byte[] getResponse() throws PageseederException {
        return this.getResponse(null, null);
    }

    public void getResponse(OutputStream out) throws PageseederException {
        this.getResponse(null, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getResponse(Map<String, List<String>> headers, OutputStream out) throws PageseederException {
        int charsetIndex;
        String newUrl;
        int status;
        if (this.connection == null) {
            throw new IllegalStateException("You need to connect to the PS server first!");
        }
        String url = this.connection.getURL().toString();
        String message = null;
        try {
            status = this.connection.getResponseCode();
            message = this.connection.getResponseMessage();
        }
        catch (IOException e) {
            throw new PageseederException("Error reading response from the Pageseeder server: " + Utils.removePasswordJsessionid(e.getMessage()), e);
        }
        this.updateExternalConfig();
        if (status == 302 && this.followRedirects && (newUrl = this.connection.getHeaderField("Location")) != null) {
            this.connection.disconnect();
            try {
                this.connectToUrl(newUrl);
                return this.getResponse(headers, out);
            }
            catch (IOException e) {
                throw new PageseederException("Redirect failed: " + Utils.removePasswordJsessionid(e.getMessage()), e);
            }
        }
        if (headers != null) {
            headers.putAll(this.connection.getHeaderFields());
        }
        this.responseContentType = this.connection.getContentType();
        this.responseContentEncoding = this.connection.getContentEncoding();
        int n = charsetIndex = this.responseContentType == null ? -1 : this.responseContentType.toLowerCase().indexOf(";charset=");
        if (charsetIndex > 0) {
            this.responseContentEncoding = this.responseContentType.substring(charsetIndex + 9);
            this.responseContentType = this.responseContentType.substring(0, charsetIndex);
        }
        if (this.responseContentType == null) {
            this.responseContentType = "text/xml";
        }
        if (this.responseContentEncoding == null) {
            this.responseContentEncoding = "UTF-8";
        }
        byte[] data = null;
        try {
            OutputStream responseAsBytes;
            InputStream stream = this.httpStatusSuccessful(status) ? this.connection.getInputStream() : this.connection.getErrorStream();
            OutputStream outputStream = responseAsBytes = out != null ? out : new ByteArrayOutputStream();
            if (stream != null) {
                try {
                    int read;
                    byte[] buffer = new byte[4096];
                    while ((read = stream.read(buffer)) != -1) {
                        responseAsBytes.write(buffer, 0, read);
                    }
                }
                finally {
                    stream.close();
                    responseAsBytes.close();
                }
            }
            if (out != null) {
                byte[] read = null;
                return read;
            }
            data = ((ByteArrayOutputStream)responseAsBytes).toByteArray();
        }
        catch (IOException ex) {
            LOGGER.error("Error reading response from the Pageseeder server: {}", (Throwable)ex);
            if (this.httpStatusSuccessful(status)) {
                throw new PageseederException("Error reading response from the Pageseeder server: " + Utils.removePasswordJsessionid(ex.getMessage()), ex);
            }
        }
        finally {
            this.connection.disconnect();
            this.connection = null;
        }
        if (!this.httpStatusSuccessful(status)) {
            ResponseHandler handler = null;
            String xmlResponse = null;
            if (this.isXMLResponse() && data.length > 0) {
                try {
                    xmlResponse = new String(data, this.responseContentEncoding);
                    handler = ResponseHandler.readResponse(xmlResponse);
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to parse XML response for error message", (Throwable)ex);
                }
            }
            String error = handler != null && handler.getMessage() != null ? handler.getMessage() : message;
            PageseederException exc = new PageseederException("HTTP Status: " + status + (String)(handler != null && handler.getErrorID() != null ? ", Error ID: " + handler.getErrorID() : "") + (String)(error != null ? ", Error message: " + error : "") + ", URL: " + Utils.removePasswordJsessionid(url));
            exc.setResponse(xmlResponse);
            exc.setHttpStatus(status);
            if (handler != null) {
                exc.setDate(handler.getDate());
                exc.setPSStackTrace(handler.getStacktrace());
            }
            throw exc;
        }
        if (status == 202 && this.isXMLResponse()) {
            return this.getThreadResponse(data);
        }
        return data;
    }

    private byte[] getThreadResponse(byte[] data) throws PageseederException {
        ThreadPoller poller = new ThreadPoller(this._config);
        poller.setPollingInterval(this.pollingIntervalMs);
        poller.setLogger(this.threadLogger);
        try {
            String resp = poller.poll(new String(data, this.responseContentEncoding));
            this.responseContentEncoding = "UTF-8";
            return resp.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new PageseederException("Failed to read data using encoding " + this.responseContentEncoding, ex);
        }
    }

    private void updateExternalConfig() {
        String cookie = this.connection.getHeaderField("Set-Cookie");
        if (cookie == null) {
            return;
        }
        for (String ck : cookie.split(";")) {
            String[] pair = ck.split("=");
            if (pair.length <= 1 || pair[0] == null || !"jsessionid".equalsIgnoreCase(pair[0]) || pair[1] == null || pair[1].isEmpty()) continue;
            this._config.setJSessionID(pair[1]);
            break;
        }
    }

    private boolean httpStatusSuccessful(int status) {
        return status >= 200 && status <= 206;
    }

    private boolean isTextResponse() {
        return this.responseContentType != null && (this.responseContentType.startsWith("text/") || this.responseContentType.endsWith("xml") || this.responseContentType.endsWith("json"));
    }

    protected boolean isXMLResponse() {
        return this.responseContentType != null && (this.responseContentType.endsWith("/xml") || this.responseContentType.endsWith("+xml"));
    }
}

