/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.Request;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class LoadingZoneDelete {
    private final String pathToDownload;
    private final String _group;
    private final String _username;
    private final ExternalConfig _config;

    public LoadingZoneDelete(String path, String group) throws PageseederException {
        this(path, group, null, null);
    }

    public LoadingZoneDelete(String path, String group, String username, ExternalConfig config) {
        this._config = config;
        this._group = group;
        this.pathToDownload = path;
        this._username = username == null ? config.getUsername() : username;
    }

    public void delete() throws PageseederException {
        String un;
        try {
            un = URLEncoder.encode(this._username, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PageseederException("Unknown encoding UTF-8", e);
        }
        Request psreq = new Request("/service/members/" + un.replace("+", "%20") + "/groups/" + this._group + "/loadingzone/delete", this._config);
        psreq.addParameter("path", this.pathToDownload);
        psreq.setHTTPMethod("POST");
        psreq.send();
        psreq.getResponse();
    }
}

