/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi;

import com.pageseeder.publishapi.PageseederException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;

public class ExternalConfig {
    private final String name;
    private final Properties _properties = new Properties();

    public ExternalConfig() {
        this("default");
    }

    public ExternalConfig(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void loadFromFile(String filename) throws PageseederException {
        block16: {
            if (!((String)filename).endsWith(".properties")) {
                filename = (String)filename + ".properties";
            }
            Object fn = null;
            try {
                if (new File((String)filename).exists()) {
                    fn = new File((String)filename).getName();
                    try (FileInputStream in = new FileInputStream((String)filename);){
                        this._properties.load(in);
                        break block16;
                    }
                }
                fn = filename;
                try (InputStream in = this.getClass().getResourceAsStream("/" + (String)filename);){
                    this._properties.load(in);
                }
            }
            catch (FileNotFoundException ex) {
                throw new PageseederException("Properties file " + fn + " not found", ex);
            }
            catch (Exception ex) {
                throw new PageseederException("Error reading properties file " + fn, ex);
            }
        }
    }

    public String getHost() {
        return this._properties.getProperty("host");
    }

    public void setHost(String host) {
        this._properties.setProperty("host", host);
    }

    public String getBackupHost() {
        return this._properties.getProperty("backupHost");
    }

    public void setBackupHost(String host) {
        this._properties.setProperty("backupHost", host);
    }

    public String getUriHost() {
        return this._properties.getProperty("uriHost");
    }

    public void setUriHost(String host) {
        this._properties.setProperty("uriHost", host);
    }

    public String getScheme() {
        return this._properties.getProperty("scheme");
    }

    public void setScheme(String scheme) {
        this._properties.setProperty("scheme", scheme);
    }

    public String getJSessionID() {
        String js = this._properties.getProperty("jsessionid");
        if (js != null && js.isEmpty()) {
            js = null;
        }
        if (js == null && "jsessionid".equals(this.getUsername())) {
            return this.getPassword();
        }
        return js;
    }

    public void setJSessionID(String jsessionid) {
        if (jsessionid != null && jsessionid.isEmpty()) {
            jsessionid = null;
        }
        this._properties.setProperty("jsessionid", jsessionid);
    }

    public int getNbOfTries() {
        if (this._properties.getProperty("nbOfTries") == null) {
            return 0;
        }
        return Integer.parseInt(this._properties.getProperty("nbOfTries"));
    }

    public void setNbOfTries(String nbOfTries) {
        this._properties.setProperty("nbOfTries", nbOfTries);
    }

    public long getDelayBetweenTries() {
        if (this._properties.getProperty("delayBetweenTries") == null) {
            return 0L;
        }
        return Long.parseLong(this._properties.getProperty("delayBetweenTries")) * 1000L;
    }

    public void setDelayBetweenTries(String delay) {
        this._properties.setProperty("delayBetweenTries", delay);
    }

    public int getPort() {
        return Integer.parseInt(this._properties.getProperty("port"));
    }

    public void setPort(String port) {
        this._properties.setProperty("port", port);
    }

    public int getBackupPort() {
        if (this._properties.getProperty("backupport") == null) {
            return this.getPort();
        }
        return Integer.parseInt(this._properties.getProperty("backupport"));
    }

    public void setBackupPort(String port) {
        this._properties.setProperty("backupport", port);
    }

    public String getUsername() {
        return this._properties.getProperty("username");
    }

    public void setUsername(String username) {
        this._properties.setProperty("username", username);
    }

    public String getAntiCSRFToken() {
        return this._properties.getProperty("antiCSRFToken");
    }

    public void setAntiCSRFToken(String token) {
        this._properties.setProperty("antiCSRFToken", token);
    }

    public String getUserToken() {
        return this._properties.getProperty("userToken");
    }

    public void setUserToken(String usertoken) {
        this._properties.setProperty("userToken", usertoken);
    }

    public String getPassword() {
        return this._properties.getProperty("password");
    }

    public void setPassword(String password) {
        this._properties.setProperty("password", password);
    }

    public String getServletPrefix() {
        String sp = this._properties.getProperty("servletPrefix");
        if (sp != null && sp.startsWith(this.getPSPrefix() + "/")) {
            return sp;
        }
        return this.getPSPrefix() + sp;
    }

    public void setServletPrefix(String servletPrefix) {
        this._properties.setProperty("servletPrefix", servletPrefix);
    }

    public String getPSPrefix() {
        return this._properties.getProperty("psPrefix");
    }

    public void setPSPrefix(String prefix) {
        this._properties.setProperty("psPrefix", prefix);
    }
}

